/*
 * Decompiled with CFR 0.152.
 */
package es.mityc.javasign.pkstore.mozilla;

import es.mityc.javasign.i18n.I18nFactory;
import es.mityc.javasign.i18n.II18nManager;
import es.mityc.javasign.pkstore.CertStoreException;
import es.mityc.javasign.pkstore.IPKStoreManager;
import es.mityc.javasign.pkstore.mozilla.IPINDialogConfigurable;
import es.mityc.javasign.pkstore.mozilla.MozillaStoreUtils;
import es.mityc.javasign.pkstore.mozilla.MozillaTokenLoginModeEnum;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.cert.CertPath;
import java.security.cert.CertificateEncodingException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mozilla.jss.CertDatabaseException;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.JSSProvider;
import org.mozilla.jss.KeyDatabaseException;
import org.mozilla.jss.asn1.INTEGER;
import org.mozilla.jss.crypto.AlreadyInitializedException;
import org.mozilla.jss.crypto.CryptoStore;
import org.mozilla.jss.crypto.CryptoToken;
import org.mozilla.jss.crypto.ObjectNotFoundException;
import org.mozilla.jss.crypto.TokenException;
import org.mozilla.jss.crypto.X509Certificate;
import org.mozilla.jss.pkcs11.PK11Module;
import org.mozilla.jss.pkcs11.PK11Token;
import org.mozilla.jss.util.IncorrectPasswordException;

public class MozillaStoreJSS
implements IPKStoreManager {
    private static final Log LOG = LogFactory.getLog(MozillaStoreJSS.class);
    private static final II18nManager I18N = I18nFactory.getI18nManager("MITyCLibCert");
    private static final String STR_FIX_JSS_BUILT_IN = "Builtin Object Token";
    private MozillaTokenLoginModeEnum loginMode = MozillaTokenLoginModeEnum.getDefault();
    private int loginTimeoutMinutes = 5;
    private static CryptoManager cm = null;

    public MozillaStoreJSS(String profile) throws CertStoreException {
        this(profile, MozillaStoreUtils.LIB_MODE.ONLY_JSS);
    }

    public MozillaStoreJSS(String profile, MozillaStoreUtils.LIB_MODE mode) throws CertStoreException {
        if (cm == null) {
            this.initialize(profile, mode);
        }
    }

    @Override
    public CertPath getCertPath(java.security.cert.X509Certificate certificate) throws CertStoreException {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    @Override
    public PrivateKey getPrivateKey(java.security.cert.X509Certificate certificate) throws CertStoreException {
        byte[] certIssuerName = null;
        INTEGER serialNumber = null;
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Cargando JSS con el manager ");
                LOG.debug(cm != null ? cm.getClass() : "Nulo");
            }
            certIssuerName = certificate.getIssuerX500Principal().getEncoded();
            serialNumber = new INTEGER(certificate.getSerialNumber());
            if (LOG.isDebugEnabled()) {
                LOG.debug("Buscando en el almac\u00e9n el certificado expedido por " + new String(certIssuerName) + " y serial " + serialNumber);
            }
            X509Certificate certJSS = cm.findCertByIssuerAndSerialNumber(certIssuerName, serialNumber);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Certificado encontrado en el almac\u00e9n: " + certJSS.getSubjectDN());
            }
            org.mozilla.jss.crypto.PrivateKey pk = cm.findPrivKeyByCert(certJSS);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Clave privada asociada encontrada:" + pk != null ? pk.toString() : "No encontrada");
            }
            String certIssuer = certificate.getIssuerDN().getName().replaceAll(" ", "");
            Enumeration enModules = cm.getModules();
            boolean modulesHasMore = enModules.hasMoreElements();
            block13: while (modulesHasMore) {
                PK11Module module = (PK11Module)enModules.nextElement();
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Modulo: " + module.getName());
                }
                modulesHasMore = enModules.hasMoreElements();
                Enumeration enTok = module.getTokens();
                boolean tokHasMore = enTok.hasMoreElements();
                while (tokHasMore) {
                    PK11Token token = (PK11Token)enTok.nextElement();
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("Token: " + token.getName());
                    }
                    tokHasMore = enTok.hasMoreElements();
                    try {
                        X509Certificate[] certs;
                        CryptoStore store = token.getCryptoStore();
                        X509Certificate[] x509CertificateArray = certs = store.getCertificates();
                        int n = certs.length;
                        int n2 = 0;
                        while (n2 < n) {
                            X509Certificate current = x509CertificateArray[n2];
                            String currentIssuer = current.getIssuerDN().getName().replaceAll(" ", "");
                            if (currentIssuer.equals(certIssuer) && current.getSerialNumber().equals(certificate.getSerialNumber())) {
                                if (LOG.isTraceEnabled()) {
                                    LOG.trace("Se ha encontrado coincidencia en el token " + token.getName());
                                }
                                cm.setThreadToken(cm.getTokenByName(token.getName()));
                                continue block13;
                            }
                            ++n2;
                        }
                        continue block13;
                    }
                    catch (Exception e) {
                        if (!LOG.isTraceEnabled()) continue;
                        LOG.error(e);
                    }
                }
            }
            return pk;
        }
        catch (Exception ex) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Error al acceder al token criptogr\u00e1fico. Reintentando logarse", ex);
            }
            try {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Procesando modulos");
                }
                Enumeration enModules = cm.getModules();
                boolean modulesHasMore = enModules.hasMoreElements();
                while (modulesHasMore) {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("Procesando modulo PK11 de mozilla");
                    }
                    PK11Module module = (PK11Module)enModules.nextElement();
                    modulesHasMore = enModules.hasMoreElements();
                    module.reloadTokens();
                    Enumeration enTok = module.getTokens();
                    boolean tokHasMore = enTok.hasMoreElements();
                    while (tokHasMore) {
                        if (LOG.isTraceEnabled()) {
                            LOG.trace("Procesando token");
                        }
                        PK11Token token = (PK11Token)enTok.nextElement();
                        if (LOG.isTraceEnabled()) {
                            LOG.trace("Token: " + token.getName());
                        }
                        tokHasMore = enTok.hasMoreElements();
                        if (STR_FIX_JSS_BUILT_IN.equals(token.getName()) || token.isInternalCryptoToken() || token.isInternalKeyStorageToken()) continue;
                        if (LOG.isTraceEnabled()) {
                            LOG.trace("Procesando token externo");
                        }
                        if (token.isPresent()) {
                            if (token.isLoggedIn()) {
                                token.logout();
                            }
                            if (LOG.isTraceEnabled()) {
                                LOG.trace("Loggin de token...");
                            }
                            int tries = 0;
                            while (tries < 3) {
                                try {
                                    token.setLoginMode(this.loginMode.getInteger());
                                    if (this.loginMode == MozillaTokenLoginModeEnum.TIMEOUT) {
                                        token.setLoginTimeoutMinutes(this.loginTimeoutMinutes);
                                    }
                                    token.login(MozillaStoreUtils.getPassHandler(IPINDialogConfigurable.MESSAGES_MODE.AUTO_TOKEN, null, I18N.getLocalMessage("i18n.mityc.cert.mozilla.8")));
                                    tries += 3;
                                    if (!LOG.isTraceEnabled()) continue;
                                    LOG.trace("Loggin de token correcto!");
                                }
                                catch (IncorrectPasswordException ex2) {
                                    LOG.info(I18N.getLocalMessage("i18n.mityc.cert.mozilla.6"));
                                    ++tries;
                                }
                                catch (TokenException ex2) {
                                    LOG.error(I18N.getLocalMessage("i18n.mityc.cert.mozilla.7", token.getName()), ex2);
                                    ++tries;
                                }
                            }
                        }
                        if (!token.isLoggedIn()) continue;
                        if (LOG.isTraceEnabled()) {
                            LOG.trace("Accediendo a token...");
                        }
                        CryptoStore store = token.getCryptoStore();
                        X509Certificate[] certs = store.getCertificates();
                        X509Certificate certCandidato = null;
                        boolean isFound = false;
                        int i = 0;
                        while (i < certs.length) {
                            certCandidato = certs[i];
                            if (LOG.isTraceEnabled()) {
                                LOG.trace("Certificado candidato: " + certCandidato.getNickname());
                            }
                            try {
                                if (new String(certCandidato.getEncoded()).equals(new String(certificate.getEncoded()))) {
                                    if (LOG.isDebugEnabled()) {
                                        LOG.debug("Correspondencia encontrada");
                                    }
                                    isFound = true;
                                    break;
                                }
                            }
                            catch (CertificateEncodingException e) {
                                LOG.error("No se pudo recuperar el certificado:" + certCandidato.getNickname());
                            }
                            ++i;
                        }
                        if (!isFound) {
                            if (!LOG.isDebugEnabled()) continue;
                            LOG.debug("No se han encontrado correspondencias en este token. Se continua");
                            continue;
                        }
                        X509Certificate certJSS = cm.findCertByIssuerAndSerialNumber(certIssuerName, serialNumber);
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Certificado encontrado en el almac\u00e9n: " + certJSS.getSubjectDN());
                        }
                        org.mozilla.jss.crypto.PrivateKey pk = cm.findPrivKeyByCert(certJSS);
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Clave privada asociada encontrada:" + pk != null ? pk.toString() : "No encontrada");
                        }
                        return pk;
                    }
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Modulos procesados sin encontrar correspondencia");
                }
                throw new CertStoreException("No se encuentra la clave privada", ex);
            }
            catch (SecurityException ex1) {
                LOG.error(I18N.getLocalMessage("i18n.mityc.cert.mozilla.9"), ex1);
                throw new CertStoreException(I18N.getLocalMessage("i18n.mityc.cert.mozilla.9"), ex1);
            }
            catch (TokenException ex1) {
                LOG.error(I18N.getLocalMessage("i18n.mityc.cert.mozilla.9"), ex1);
                throw new CertStoreException(I18N.getLocalMessage("i18n.mityc.cert.mozilla.9"), ex1);
            }
            catch (ObjectNotFoundException ex1) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Error al buscar la clave privada", ex);
                }
                throw new CertStoreException(ex);
            }
        }
    }

    @Override
    public Provider getProvider(java.security.cert.X509Certificate cert) {
        return new JSSProvider();
    }

    @Override
    public List<java.security.cert.X509Certificate> getSignCertificates() throws CertStoreException {
        return this.getCertificates(true);
    }

    @Override
    public List<java.security.cert.X509Certificate> getPublicCertificates() throws CertStoreException {
        return this.getCertificates(false);
    }

    private List<java.security.cert.X509Certificate> getCertificates(boolean getPrivates) throws CertStoreException {
        if (cm == null) {
            LOG.error("No se ha cargado el m\u00f3dulo CSP para Mozilla");
            throw new CertStoreException(I18N.getLocalMessage("i18n.mityc.cert.mozilla.9"));
        }
        ArrayList<java.security.cert.X509Certificate> allCertsPublic = new ArrayList<java.security.cert.X509Certificate>();
        ArrayList<java.security.cert.X509Certificate> allCertsPrivate = new ArrayList<java.security.cert.X509Certificate>();
        try {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Procesando modulos");
            }
            Enumeration enModules = cm.getModules();
            boolean modulesHasMore = enModules.hasMoreElements();
            while (modulesHasMore) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Procesando modulo PK11 de mozilla");
                }
                PK11Module module = (PK11Module)enModules.nextElement();
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Modulo: " + module.getName());
                }
                modulesHasMore = enModules.hasMoreElements();
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Recargando tokens");
                }
                module.reloadTokens();
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Tokens recargados");
                }
                Enumeration enTok = module.getTokens();
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Tokens del m\u00f3dulo obtenidos: " + enTok.hasMoreElements());
                }
                boolean tokHasMore = enTok.hasMoreElements();
                while (tokHasMore) {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("Procesando token");
                    }
                    PK11Token token = (PK11Token)enTok.nextElement();
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("Token: " + token.getName());
                    }
                    tokHasMore = enTok.hasMoreElements();
                    if (STR_FIX_JSS_BUILT_IN.equals(token.getName()) || token.isInternalCryptoToken() || token.isInternalKeyStorageToken()) continue;
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("Procesando token externo");
                    }
                    if (!token.isPresent()) continue;
                    if (token.isLoggedIn()) {
                        boolean doLogout;
                        boolean bl = doLogout = this.loginMode != MozillaTokenLoginModeEnum.getLoginMode(token.getLoginMode());
                        if (!doLogout && this.loginMode == MozillaTokenLoginModeEnum.TIMEOUT) {
                            boolean bl2 = doLogout = this.loginTimeoutMinutes != token.getLoginTimeoutMinutes();
                        }
                        if (doLogout) {
                            token.logout();
                        }
                    }
                    if (!token.isLoggedIn()) {
                        if (LOG.isTraceEnabled()) {
                            LOG.trace("Loggin de token...");
                        }
                        int tries = 0;
                        while (tries < 3) {
                            try {
                                token.setLoginMode(this.loginMode.getInteger());
                                if (this.loginMode == MozillaTokenLoginModeEnum.TIMEOUT) {
                                    token.setLoginTimeoutMinutes(this.loginTimeoutMinutes);
                                }
                                token.login(MozillaStoreUtils.getPassHandler(IPINDialogConfigurable.MESSAGES_MODE.AUTO_TOKEN, null, I18N.getLocalMessage("i18n.mityc.cert.mozilla.8")));
                                tries += 3;
                                if (LOG.isTraceEnabled()) {
                                    LOG.trace("Loggin de token correcto!");
                                }
                                cm.setThreadToken((CryptoToken)token);
                            }
                            catch (IncorrectPasswordException ex) {
                                LOG.info(I18N.getLocalMessage("i18n.mityc.cert.mozilla.6"));
                                ++tries;
                            }
                            catch (TokenException ex) {
                                LOG.error(I18N.getLocalMessage("i18n.mityc.cert.mozilla.7", token.getName()), ex);
                                ++tries;
                            }
                        }
                    }
                    if (!token.isLoggedIn()) continue;
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("Accediendo a token...");
                    }
                    CryptoStore store = token.getCryptoStore();
                    X509Certificate[] certs = store.getCertificates();
                    int i = 0;
                    while (i < certs.length) {
                        java.security.cert.X509Certificate cert = MozillaStoreUtils.convert(certs[i]);
                        boolean[] usage = cert.getKeyUsage();
                        if (cert != null && (usage == null || usage[0] || usage[1])) {
                            allCertsPrivate.add(cert);
                        } else {
                            allCertsPublic.add(cert);
                        }
                        ++i;
                    }
                }
                if (!LOG.isTraceEnabled()) continue;
                LOG.trace("Modulo P11 procesado");
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace("Pide certificados");
            }
            X509Certificate[] certs = cm.getInternalKeyStorageToken().getCryptoStore().getCertificates();
            if (LOG.isTraceEnabled()) {
                if (certs != null) {
                    LOG.trace("Se han obtenido " + certs.length + " certificados");
                } else {
                    LOG.trace("No hay certificados disponibles");
                }
            }
            int i = 0;
            while (i < certs.length) {
                block41: {
                    try {
                        if (LOG.isTraceEnabled()) {
                            LOG.trace("Buscando clave privada para: " + certs[i]);
                        }
                        if (cm.findPrivKeyByCert(certs[i]) != null) {
                            java.security.cert.X509Certificate cert = MozillaStoreUtils.convert(certs[i]);
                            allCertsPrivate.add(cert);
                        } else {
                            allCertsPublic.add(MozillaStoreUtils.convert(certs[i]));
                        }
                    }
                    catch (ObjectNotFoundException ex) {
                        if (!LOG.isTraceEnabled()) break block41;
                        LOG.trace("No hay clave privada");
                    }
                }
                ++i;
            }
        }
        catch (SecurityException ex) {
            LOG.error(I18N.getLocalMessage("i18n.mityc.cert.mozilla.9"), ex);
            throw new CertStoreException(I18N.getLocalMessage("i18n.mityc.cert.mozilla.9"), ex);
        }
        catch (TokenException ex) {
            LOG.error(I18N.getLocalMessage("i18n.mityc.cert.mozilla.9"), ex);
            throw new CertStoreException(I18N.getLocalMessage("i18n.mityc.cert.mozilla.9"), ex);
        }
        if (getPrivates) {
            return allCertsPrivate;
        }
        return allCertsPublic;
    }

    @Override
    public List<java.security.cert.X509Certificate> getTrustCertificates() throws CertStoreException {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    private synchronized void initialize(String profile, MozillaStoreUtils.LIB_MODE mode) throws CertStoreException {
        MozillaStoreUtils.initialize(profile, mode);
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Se levanta el proveedor JSS");
            }
            CryptoManager.InitializationValues iv = new CryptoManager.InitializationValues(profile);
            iv.installJSSProvider = false;
            CryptoManager.initialize((CryptoManager.InitializationValues)iv);
            cm = CryptoManager.getInstance();
        }
        catch (UnsatisfiedLinkError e) {
            LOG.debug("No se pudo cargar la instancia de la librer\u00eda JSS: " + e.getMessage(), e);
            throw new CertStoreException(e);
        }
        catch (KeyDatabaseException ex) {
            LOG.error(I18N.getLocalMessage("i18n.mityc.cert.mozilla.2", ex.getMessage()), ex);
        }
        catch (CertDatabaseException ex) {
            LOG.error(I18N.getLocalMessage("i18n.mityc.cert.mozilla.2", ex.getMessage()), ex);
        }
        catch (AlreadyInitializedException ex) {
        }
        catch (GeneralSecurityException ex) {
            LOG.error(I18N.getLocalMessage("i18n.mityc.cert.mozilla.2", ex.getMessage()), ex);
        }
        catch (CryptoManager.NotInitializedException ex) {
            LOG.error(I18N.getLocalMessage("i18n.mityc.cert.mozilla.2", ex.getMessage()), ex);
        }
        if (cm != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Capturando slot para peticiones de PIN");
            }
            cm.setPasswordCallback(MozillaStoreUtils.getPassHandler(IPINDialogConfigurable.MESSAGES_MODE.AUTO, null, null));
        }
    }

    public MozillaTokenLoginModeEnum getLoginMode() {
        return this.loginMode;
    }

    public void setLoginMode(MozillaTokenLoginModeEnum mode) {
        this.loginMode = mode;
    }

    public int getLoginTimeoutMinutes() {
        return this.loginTimeoutMinutes;
    }

    public void setLoginTimeoutMinutes(int timeoutMinutes) {
        this.loginTimeoutMinutes = timeoutMinutes;
    }
}

