/*
 * Decompiled with CFR 0.152.
 */
package es.mityc.javasign.pkstore.mscapi.mityc;

import es.mityc.javasign.exception.CopyFileException;
import es.mityc.javasign.i18n.I18nFactory;
import es.mityc.javasign.i18n.II18nManager;
import es.mityc.javasign.pkstore.CertStoreException;
import es.mityc.javasign.pkstore.IPKStoreManager;
import es.mityc.javasign.pkstore.IPassStoreKS;
import es.mityc.javasign.pkstore.keystore.KeyTool;
import es.mityc.javasign.pkstore.mscapi.mityc.SunMSCAPI_MITyC;
import es.mityc.javasign.utils.CopyFilesTool;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.cert.CertPath;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;

public class MSCAPIMITyCStore
implements IPKStoreManager {
    private static final II18nManager I18N = I18nFactory.getI18nManager("MITyCLibCert");
    private static final String MY_STORE = "Windows-MY";
    private static final String ROOT_STORE = "Windows-ROOT";
    private static final String CA_STORE = "Windows-CA";
    private static final String LOCAL_MACHINE_MY_STORE = "Windows-LocalMachine-MY";
    private static final String LOCAL_MACHINE_ROOT_STORE = "Windows-LocalMachine-ROOT";
    private static final String LOCAL_MACHINE_CA_STORE = "Windows-LocalMachine-CA";
    private static boolean initialized = false;
    private IPassStoreKS passHandler;
    private LocationStoreType locationStore;

    private synchronized void copyLibrary() throws CopyFileException {
        if (!initialized) {
            CopyFilesTool cft = new CopyFilesTool("libs/sunmscapimityc/MITyCLibCertJNI_sunmscapimityc.properties", this.getClass().getClassLoader());
            cft.copyFilesOS(null, "explorer", true);
            initialized = true;
        }
    }

    public MSCAPIMITyCStore(IPassStoreKS passStoreHandler) throws CertStoreException {
        this(passStoreHandler, LocationStoreType.CurrentUser);
    }

    public MSCAPIMITyCStore(IPassStoreKS passStoreHandler, LocationStoreType location) throws CertStoreException {
        this.locationStore = location;
        try {
            this.copyLibrary();
        }
        catch (CopyFileException ex) {
            throw new CertStoreException(I18N.getLocalMessage("i18n.mityc.cert.mscapimityc.1"), ex);
        }
        this.passHandler = passStoreHandler == null ? new NullPassStorePK() : passStoreHandler;
    }

    @Override
    public CertPath getCertPath(X509Certificate certificate) throws CertStoreException {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    @Override
    public PrivateKey getPrivateKey(X509Certificate certificate) throws CertStoreException {
        try {
            String storeName = null;
            switch (this.locationStore) {
                case CurrentUser: {
                    storeName = MY_STORE;
                    break;
                }
                case LocalMachine: {
                    storeName = LOCAL_MACHINE_MY_STORE;
                }
            }
            KeyStore ks = KeyStore.getInstance(storeName, new SunMSCAPI_MITyC());
            ks.load(null, null);
            PrivateKey resultado = KeyTool.findPrivateKey(ks, certificate, this.passHandler);
            return resultado;
        }
        catch (KeyStoreException ex) {
            throw new CertStoreException(I18N.getLocalMessage("i18n.mityc.cert.mscapi.1", ex.getMessage(), ex));
        }
        catch (NoSuchAlgorithmException ex) {
            throw new CertStoreException(I18N.getLocalMessage("i18n.mityc.cert.mscapi.2", ex.getMessage(), ex));
        }
        catch (CertificateException ex) {
            throw new CertStoreException(I18N.getLocalMessage("i18n.mityc.cert.mscapi.3", ex.getMessage(), ex));
        }
        catch (IOException ex) {
            throw new CertStoreException(I18N.getLocalMessage("i18n.mityc.cert.mscapi.4", ex.getMessage(), ex));
        }
    }

    @Override
    public Provider getProvider(X509Certificate certificate) {
        return new SunMSCAPI_MITyC();
    }

    @Override
    public List<X509Certificate> getSignCertificates() throws CertStoreException {
        try {
            String storeName = null;
            switch (this.locationStore) {
                case CurrentUser: {
                    storeName = MY_STORE;
                    break;
                }
                case LocalMachine: {
                    storeName = LOCAL_MACHINE_MY_STORE;
                }
            }
            KeyStore ks = KeyStore.getInstance(storeName, new SunMSCAPI_MITyC());
            ks.load(null, null);
            return KeyTool.getCertificatesWithKeys(ks);
        }
        catch (KeyStoreException ex) {
            throw new CertStoreException(I18N.getLocalMessage("i18n.mityc.cert.mscapi.1", ex.getMessage(), ex));
        }
        catch (NoSuchAlgorithmException ex) {
            throw new CertStoreException(I18N.getLocalMessage("i18n.mityc.cert.mscapi.2", ex.getMessage(), ex));
        }
        catch (CertificateException ex) {
            throw new CertStoreException(I18N.getLocalMessage("i18n.mityc.cert.mscapi.3", ex.getMessage(), ex));
        }
        catch (IOException ex) {
            throw new CertStoreException(I18N.getLocalMessage("i18n.mityc.cert.mscapi.4", ex.getMessage(), ex));
        }
    }

    @Override
    public List<X509Certificate> getTrustCertificates() throws CertStoreException {
        try {
            String storeName = null;
            switch (this.locationStore) {
                case CurrentUser: {
                    storeName = ROOT_STORE;
                    break;
                }
                case LocalMachine: {
                    storeName = LOCAL_MACHINE_ROOT_STORE;
                }
            }
            KeyStore ks = KeyStore.getInstance(storeName, new SunMSCAPI_MITyC());
            ks.load(null, null);
            ArrayList<X509Certificate> lista = new ArrayList<X509Certificate>();
            lista.addAll(KeyTool.getTrustCertificates(ks));
            switch (this.locationStore) {
                case CurrentUser: {
                    storeName = CA_STORE;
                    break;
                }
                case LocalMachine: {
                    storeName = LOCAL_MACHINE_CA_STORE;
                }
            }
            ks = KeyStore.getInstance(storeName, new SunMSCAPI_MITyC());
            ks.load(null, null);
            lista.addAll(KeyTool.getTrustCertificates(ks));
            return lista;
        }
        catch (KeyStoreException ex) {
            throw new CertStoreException(I18N.getLocalMessage("i18n.mityc.cert.mscapi.1", ex.getMessage(), ex));
        }
        catch (NoSuchAlgorithmException ex) {
            throw new CertStoreException(I18N.getLocalMessage("i18n.mityc.cert.mscapi.2", ex.getMessage(), ex));
        }
        catch (CertificateException ex) {
            throw new CertStoreException(I18N.getLocalMessage("i18n.mityc.cert.mscapi.3", ex.getMessage(), ex));
        }
        catch (IOException ex) {
            throw new CertStoreException(I18N.getLocalMessage("i18n.mityc.cert.mscapi.4", ex.getMessage(), ex));
        }
    }

    @Override
    public List<X509Certificate> getPublicCertificates() throws CertStoreException {
        try {
            String storeName = null;
            switch (this.locationStore) {
                case CurrentUser: {
                    storeName = MY_STORE;
                    break;
                }
                case LocalMachine: {
                    storeName = LOCAL_MACHINE_MY_STORE;
                }
            }
            KeyStore ks = KeyStore.getInstance(storeName, new SunMSCAPI_MITyC());
            ks.load(null, null);
            return KeyTool.getCertificatesWithoutKeys(ks);
        }
        catch (KeyStoreException ex) {
            throw new CertStoreException(I18N.getLocalMessage("i18n.mityc.cert.mscapi.1", ex.getMessage(), ex));
        }
        catch (NoSuchAlgorithmException ex) {
            throw new CertStoreException(I18N.getLocalMessage("i18n.mityc.cert.mscapi.2", ex.getMessage(), ex));
        }
        catch (CertificateException ex) {
            throw new CertStoreException(I18N.getLocalMessage("i18n.mityc.cert.mscapi.3", ex.getMessage(), ex));
        }
        catch (IOException ex) {
            throw new CertStoreException(I18N.getLocalMessage("i18n.mityc.cert.mscapi.4", ex.getMessage(), ex));
        }
    }

    public static enum LocationStoreType {
        CurrentUser,
        LocalMachine;

    }

    public class NullPassStorePK
    implements IPassStoreKS {
        @Override
        public char[] getPassword(X509Certificate certificate, String alias) {
            return new char[0];
        }
    }
}

