/*
 * Decompiled with CFR 0.152.
 */
package adsi.org.apache.xml.security.utils;

import adsi.org.apache.xml.security.algorithms.MessageDigestAlgorithm;
import java.io.ByteArrayOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DigesterOutputStream
extends ByteArrayOutputStream {
    static final byte[] none = "error".getBytes();
    final MessageDigestAlgorithm mda;
    static Log log = LogFactory.getLog(DigesterOutputStream.class.getName());

    public DigesterOutputStream(MessageDigestAlgorithm mda) {
        this.mda = mda;
    }

    @Override
    public byte[] toByteArray() {
        return none;
    }

    @Override
    public void write(byte[] arg0) {
        this.write(arg0, 0, arg0.length);
    }

    @Override
    public void write(int arg0) {
        this.mda.update((byte)arg0);
    }

    @Override
    public void write(byte[] arg0, int arg1, int arg2) {
        if (log.isDebugEnabled()) {
            log.debug("Pre-digested input:");
            StringBuffer sb = new StringBuffer(arg2);
            int i = arg1;
            while (i < arg1 + arg2) {
                sb.append((char)arg0[i]);
                ++i;
            }
            log.debug(sb.toString());
        }
        this.mda.update(arg0, arg1, arg2);
    }

    public byte[] getDigestValue() {
        return this.mda.digest();
    }
}

