/*
 * Decompiled with CFR 0.152.
 */
package es.mityc.firmaJava.libreria.xades.elementos;

import es.mityc.firmaJava.libreria.xades.elementos.AbstractXMLElement;
import es.mityc.firmaJava.libreria.xades.errores.InvalidInfoNodeException;
import java.math.BigInteger;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XMLDataIntegerType
extends AbstractXMLElement {
    protected BigInteger value;

    public XMLDataIntegerType(BigInteger value) {
        this.value = value;
    }

    @Override
    public void addContent(Element element) throws InvalidInfoNodeException {
        if (this.value == null) {
            throw new InvalidInfoNodeException("Informaci\u00f3n insuficiente para escribir nodo XMLDataStringType");
        }
        element.setTextContent(this.value.toString());
    }

    @Override
    public boolean equals(Object obj) {
        String data;
        XMLDataIntegerType xdst;
        return obj instanceof XMLDataIntegerType ? this.value.equals(xdst = (XMLDataIntegerType)obj) : obj instanceof String && this.value.equals(data = (String)obj);
    }

    @Override
    public void load(Element element) throws InvalidInfoNodeException {
        Node node = XMLDataIntegerType.getFirstNonvoidNode(element);
        if (node.getNodeType() != 3) {
            throw new InvalidInfoNodeException("Nodo xsd:string no contiene CDATA como primer valor");
        }
        try {
            String strvalue = node.getNodeValue();
            if (strvalue == null) {
                throw new InvalidInfoNodeException("Contenido de valor de xsd.string vac\u00edo");
            }
            this.value = new BigInteger(strvalue);
        }
        catch (NumberFormatException ex) {
            throw new InvalidInfoNodeException("Contenido de valor de xsd.integer no num\u00e9rico");
        }
    }

    public BigInteger getValue() {
        return this.value;
    }

    public void setValue(BigInteger value) {
        this.value = value;
    }
}

