/*
 * Decompiled with CFR 0.152.
 */
package es.mityc.javasign.pkstore.mitycstore.mantainer;

import es.mityc.javasign.i18n.I18nFactory;
import es.mityc.javasign.i18n.II18nManager;
import es.mityc.javasign.pkstore.mitycstore.CertUtil;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public class CertTblModel
extends AbstractTableModel {
    private static final II18nManager I18N = I18nFactory.getI18nManager("MITyCLibCert");
    private String[] columnNames = new String[3];
    private Object[][] data = null;

    public CertTblModel(List<X509Certificate> listCertificates) {
        this.columnNames[0] = I18N.getLocalMessage("i18n.mityc.cert.mityc.47");
        this.columnNames[1] = I18N.getLocalMessage("i18n.mityc.cert.mityc.48");
        this.columnNames[2] = I18N.getLocalMessage("i18n.mityc.cert.mityc.49");
        int rows = 0;
        if (listCertificates != null) {
            rows = listCertificates.size();
        }
        this.data = new Object[rows][4];
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
        X509Certificate certTemp = null;
        int a = 0;
        while (a < rows) {
            certTemp = listCertificates.get(a);
            this.data[a][0] = this.getName(certTemp, SUBJECT_OR_ISSUER.SUBJECT);
            this.data[a][1] = this.getName(certTemp, SUBJECT_OR_ISSUER.ISSUER);
            this.data[a][2] = sdf.format(certTemp.getNotAfter());
            this.data[a][3] = certTemp;
            ++a;
        }
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public int getRowCount() {
        return this.data.length;
    }

    @Override
    public Object getValueAt(int fil, int col) {
        return this.data[fil][col];
    }

    public X509Certificate getCertificate(int row) {
        if (row >= 0 && row < this.getRowCount()) {
            return (X509Certificate)this.data[row][3];
        }
        return null;
    }

    @Override
    public String getColumnName(int col) {
        return this.columnNames[col];
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return String.class;
    }

    private String getName(X509Certificate cert, SUBJECT_OR_ISSUER tipo) {
        String retorno = "";
        retorno = tipo == SUBJECT_OR_ISSUER.ISSUER ? CertUtil.extractName(cert.getIssuerX500Principal()) : CertUtil.extractName(cert.getSubjectX500Principal());
        return retorno;
    }

    public static enum SUBJECT_OR_ISSUER {
        SUBJECT,
        ISSUER;

    }
}

