/*
 * Decompiled with CFR 0.152.
 */
package es.mityc.javasign.pkstore.mitycstore.mantainer;

import es.mityc.javasign.i18n.I18nFactory;
import es.mityc.javasign.i18n.II18nManager;
import es.mityc.javasign.pkstore.mitycstore.mantainer.CertificadoModeloTree;
import es.mityc.javasign.pkstore.mitycstore.mantainer.CertsFilter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DialogoCert
extends JDialog {
    Log logger = LogFactory.getLog(DialogoCert.class);
    private static final II18nManager I18N = I18nFactory.getI18nManager("MITyCLibCert");
    private static final String STR_ICON_CERT = "/es/mityc/javasign/pkstore/mitycstore/Images/CertSmall.png";
    private static final int WIDTH = 585;
    private static final int HEIGHT = 355;
    private X509Certificate cert = null;
    private Frame owner = null;
    private JPanel panPrincipal = null;
    private JButton jCerrarButton = null;
    private JButton jExportarCertificadoButton = null;
    private JScrollPane jDatosCertificadoScrollPane = null;
    private JTree jTreeDatoCertificado = null;

    protected DialogoCert(Frame ownr) {
        super(ownr, true);
        this.owner = ownr;
        this.dialogInit();
    }

    protected void muestraInfo(X509Certificate certificate) {
        this.cert = certificate;
        this.muestraDialogo();
    }

    private void muestraDialogo() {
        if (this.cert != null) {
            ImageIcon iconoCertificado = new ImageIcon(this.getClass().getResource(STR_ICON_CERT));
            if (iconoCertificado != null) {
                DefaultTreeCellRenderer renderer = new DefaultTreeCellRenderer();
                renderer.setLeafIcon(iconoCertificado);
                renderer.setOpenIcon(iconoCertificado);
                renderer.setClosedIcon(iconoCertificado);
                renderer.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0, 0), 2));
                this.jTreeDatoCertificado.setCellRenderer(renderer);
            }
            DefaultMutableTreeNode root = new DefaultMutableTreeNode(I18N.getLocalMessage("i18n.mityc.cert.mityc.50"));
            CertificadoModeloTree cmt = new CertificadoModeloTree(root, this.cert);
            this.jTreeDatoCertificado.setModel(cmt);
            cmt.reload();
            this.setVisible(true);
            this.jTreeDatoCertificado.validate();
            this.jTreeDatoCertificado.repaint();
            int rows = this.jTreeDatoCertificado.getRowCount();
            int i = 0;
            while (i < rows - 1) {
                this.jTreeDatoCertificado.expandRow(i);
                ++i;
            }
        } else {
            this.logger.debug("No se recibi\u00f3 el certificado");
        }
    }

    @Override
    protected void dialogInit() {
        super.dialogInit();
        this.panPrincipal = new JPanel();
        this.jDatosCertificadoScrollPane = new JScrollPane();
        this.jTreeDatoCertificado = new JTree();
        this.jCerrarButton = new JButton();
        this.jExportarCertificadoButton = new JButton();
        this.setLayout(new GridBagLayout());
        this.panPrincipal.setLayout(new GridBagLayout());
        GridBagConstraints datosCertificadoScrollPaneConstraints = new GridBagConstraints();
        datosCertificadoScrollPaneConstraints.gridx = 0;
        datosCertificadoScrollPaneConstraints.gridy = 1;
        datosCertificadoScrollPaneConstraints.weightx = 1.0;
        datosCertificadoScrollPaneConstraints.weighty = 1.0;
        datosCertificadoScrollPaneConstraints.gridwidth = 4;
        datosCertificadoScrollPaneConstraints.fill = 1;
        datosCertificadoScrollPaneConstraints.insets = new Insets(10, 10, 10, 10);
        this.jDatosCertificadoScrollPane.setBorder(BorderFactory.createTitledBorder(I18N.getLocalMessage("i18n.mityc.cert.mityc.51")));
        this.jDatosCertificadoScrollPane.setViewportView(this.jTreeDatoCertificado);
        GridBagConstraints cerrarButtonConstraints = new GridBagConstraints();
        cerrarButtonConstraints.gridx = 1;
        cerrarButtonConstraints.gridy = 2;
        cerrarButtonConstraints.insets = new Insets(0, 225, 10, 10);
        this.jCerrarButton.setText("Cerrar");
        this.jCerrarButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogoCert.this.jCerrarButtonActionPerformed();
            }
        });
        GridBagConstraints exportarButtonConstraints = new GridBagConstraints();
        exportarButtonConstraints.gridx = 2;
        exportarButtonConstraints.gridy = 2;
        exportarButtonConstraints.insets = new Insets(0, 78, 10, 0);
        this.jExportarCertificadoButton.setText(I18N.getLocalMessage("i18n.mityc.cert.mityc.52"));
        this.jExportarCertificadoButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogoCert.this.jExportarCertButtonActionPerformed(DialogoCert.this.cert);
            }
        });
        this.panPrincipal.add((Component)this.jDatosCertificadoScrollPane, datosCertificadoScrollPaneConstraints);
        this.panPrincipal.add((Component)this.jCerrarButton, cerrarButtonConstraints);
        this.panPrincipal.add((Component)this.jExportarCertificadoButton, exportarButtonConstraints);
        GridBagConstraints panPrincipalConstraints = new GridBagConstraints();
        panPrincipalConstraints.fill = 1;
        panPrincipalConstraints.weightx = 1.0;
        panPrincipalConstraints.weighty = 1.0;
        this.add((Component)this.panPrincipal, panPrincipalConstraints);
        this.setTitle(I18N.getLocalMessage("i18n.mityc.cert.mityc.50"));
        this.setSize(585, 355);
        this.setLocationRelativeTo(this.owner);
        if (this.owner == null) {
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            this.setLocation(screenSize.width / 2 - this.getWidth() / 2, screenSize.height / 2 - this.getHeight() / 2);
        }
        this.setModal(true);
        this.setResizable(false);
    }

    private void jCerrarButtonActionPerformed() {
        this.setVisible(false);
        this.dispose();
    }

    /*
     * Loose catch block
     */
    private void jExportarCertButtonActionPerformed(X509Certificate certMostrado) {
        String destino = null;
        JFileChooser chooser = new JFileChooser();
        chooser.setDialogTitle(I18N.getLocalMessage("i18n.mityc.cert.mityc.53"));
        chooser.setFileFilter(new CertsFilter(true));
        chooser.setDialogType(1);
        int returnVal = chooser.showDialog(this.owner, I18N.getLocalMessage("i18n.mityc.cert.mityc.52"));
        if (returnVal == 0) {
            destino = chooser.getSelectedFile().getAbsolutePath();
        }
        if (destino == null) {
            return;
        }
        destino = !destino.contains(".") ? String.valueOf(destino) + ".cer" : String.valueOf(destino.substring(0, destino.lastIndexOf("."))) + ".cer";
        if (certMostrado == null) {
            this.logger.debug("No se recibi\u00f3 el certificado");
            JOptionPane.showMessageDialog(this, I18N.getLocalMessage("i18n.mityc.cert.mityc.16"), I18N.getLocalMessage("i18n.mityc.cert.mityc.52"), 0);
            return;
        }
        FilterOutputStream f = null;
        try {
            try {
                f = new BufferedOutputStream(new FileOutputStream(destino));
                f.write(certMostrado.getEncoded());
                ((BufferedOutputStream)f).flush();
            }
            catch (FileNotFoundException e) {
                this.logger.error(I18N.getLocalMessage("i18n.mityc.cert.mityc.54"), e);
                try {
                    if (f != null) {
                        f.close();
                    }
                }
                catch (IOException iOException) {}
            }
            catch (IOException e) {
                this.logger.error(I18N.getLocalMessage("i18n.mityc.cert.mityc.55"), e);
                try {
                    if (f != null) {
                        f.close();
                    }
                }
                catch (IOException iOException) {}
            }
            catch (CertificateEncodingException e) {
                this.logger.error(I18N.getLocalMessage("i18n.mityc.cert.mityc.56"), e);
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                try {
                    if (f != null) {
                        f.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        finally {
            try {
                if (f != null) {
                    f.close();
                }
            }
            catch (IOException iOException) {}
        }
    }
}

