/*
 * Decompiled with CFR 0.152.
 */
package es.mityc.javasign.pkstore.mozilla;

import es.mityc.javasign.i18n.I18nFactory;
import es.mityc.javasign.i18n.II18nManager;
import es.mityc.javasign.pkstore.mozilla.IPINDialogConfigurable;
import es.mityc.javasign.pkstore.mozilla.PINDialog;
import java.util.MissingResourceException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mozilla.jss.util.Password;
import org.mozilla.jss.util.PasswordCallback;
import org.mozilla.jss.util.PasswordCallbackInfo;

public class PassStoreMozilla
implements PasswordCallback,
IPINDialogConfigurable {
    private static final Log LOG = LogFactory.getLog(PassStoreMozilla.class);
    private static final II18nManager I18N = I18nFactory.getI18nManager("MITyCLibCert");
    private String title = null;
    private String pinMessage = null;
    private IPINDialogConfigurable.MESSAGES_MODE mode = IPINDialogConfigurable.MESSAGES_MODE.AUTO;

    public Password getPasswordAgain(PasswordCallbackInfo info) throws PasswordCallback.GiveUpException {
        try {
            PINDialog pinDialog = new PINDialog(null);
            switch (this.mode) {
                case AUTO_TOKEN: {
                    pinDialog.setTitle(info.getName());
                    if (this.pinMessage == null) break;
                    pinDialog.setPINMessage(this.pinMessage);
                    break;
                }
                case EXPLICIT: {
                    if (this.title != null) {
                        pinDialog.setTitle(this.title);
                    }
                    if (this.pinMessage == null) break;
                    pinDialog.setPINMessage(this.pinMessage);
                }
            }
            pinDialog.pack();
            pinDialog.setVisible(true);
            if (pinDialog.isCancelado()) {
                throw new PasswordCallback.GiveUpException();
            }
            char[] pass = pinDialog.getPassword();
            pinDialog.dispose();
            return new Password(pass);
        }
        catch (MissingResourceException ex) {
            LOG.error(I18N.getLocalMessage("i18n.mityc.cert.smartcards.GUI.1"), ex);
            throw new PasswordCallback.GiveUpException();
        }
    }

    public Password getPasswordFirstAttempt(PasswordCallbackInfo info) throws PasswordCallback.GiveUpException {
        try {
            PINDialog pinDialog = new PINDialog(null);
            switch (this.mode) {
                case AUTO_TOKEN: {
                    pinDialog.setTitle(info.getName());
                    if (this.pinMessage == null) break;
                    pinDialog.setPINMessage(this.pinMessage);
                    break;
                }
                case EXPLICIT: {
                    if (this.title != null) {
                        pinDialog.setTitle(this.title);
                    }
                    if (this.pinMessage == null) break;
                    pinDialog.setPINMessage(this.pinMessage);
                }
            }
            pinDialog.pack();
            pinDialog.setVisible(true);
            if (pinDialog.isCancelado()) {
                throw new PasswordCallback.GiveUpException();
            }
            char[] pass = pinDialog.getPassword();
            pinDialog.dispose();
            return new Password(pass);
        }
        catch (MissingResourceException ex) {
            LOG.error(I18N.getLocalMessage("i18n.mityc.cert.smartcards.GUI.1"), ex);
            throw new PasswordCallback.GiveUpException();
        }
    }

    @Override
    public void setPINMessage(String message) {
        this.pinMessage = new String(message);
    }

    @Override
    public void setTitle(String titleWindow) {
        this.title = new String(titleWindow);
    }

    @Override
    public void setMessagesMode(IPINDialogConfigurable.MESSAGES_MODE messagesMode) {
        this.mode = messagesMode;
    }
}

