/*
 * Decompiled with CFR 0.152.
 */
package es.mityc.javasign.pkstore.mscapi.mityc;

import es.mityc.javasign.pkstore.mscapi.mityc.Key;
import java.io.ObjectStreamException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.KeyRep;
import sun.security.rsa.RSAPublicKeyImpl;

class RSAPublicKey
extends Key
implements java.security.interfaces.RSAPublicKey {
    private byte[] publicKeyBlob = null;
    private byte[] encoding = null;
    private BigInteger modulus = null;
    private BigInteger exponent = null;

    RSAPublicKey(long hCryptProv, long hCryptKey, int keyLength) {
        super(hCryptProv, hCryptKey, keyLength);
    }

    @Override
    public String getAlgorithm() {
        return "RSA";
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("RSAPublicKey [size=").append(this.keyLength).append(" bits, type=").append(RSAPublicKey.getKeyType(this.hCryptKey)).append(", container=").append(RSAPublicKey.getContainerName(this.hCryptProv)).append("]\n  modulus: ").append(this.getModulus()).append("\n  public exponent: ").append(this.getPublicExponent());
        return sb.toString();
    }

    @Override
    public BigInteger getPublicExponent() {
        if (this.exponent == null) {
            this.publicKeyBlob = this.getPublicKeyBlob(this.hCryptKey);
            this.exponent = new BigInteger(this.getExponent(this.publicKeyBlob));
        }
        return this.exponent;
    }

    @Override
    public BigInteger getModulus() {
        if (this.modulus == null) {
            this.publicKeyBlob = this.getPublicKeyBlob(this.hCryptKey);
            this.modulus = new BigInteger(this.getModulus(this.publicKeyBlob));
        }
        return this.modulus;
    }

    @Override
    public String getFormat() {
        return "X.509";
    }

    @Override
    public byte[] getEncoded() {
        if (this.encoding == null) {
            try {
                this.encoding = new RSAPublicKeyImpl(this.getModulus(), this.getPublicExponent()).getEncoded();
            }
            catch (InvalidKeyException invalidKeyException) {
                // empty catch block
            }
        }
        return this.encoding;
    }

    protected Object writeReplace() throws ObjectStreamException {
        return new KeyRep(KeyRep.Type.PUBLIC, this.getAlgorithm(), this.getFormat(), this.getEncoded());
    }

    private native byte[] getPublicKeyBlob(long var1);

    private native byte[] getExponent(byte[] var1);

    private native byte[] getModulus(byte[] var1);
}

