/*
 * Decompiled with CFR 0.152.
 */
package es.mityc.javasign.utils;

import com.sun.org.apache.xerces.internal.impl.dv.util.Base64;
import es.mityc.javasign.utils.SimpleAuthenticator;
import java.io.IOException;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ProxyUtil {
    static Log log = LogFactory.getLog(ProxyUtil.class);

    public static HttpURLConnection getConnection(String URL2) throws MalformedURLException, IOException {
        HttpURLConnection conn = null;
        if (System.getProperty("http.proxySet") != null && Boolean.parseBoolean(System.getProperty("http.proxySet")) && !ProxyUtil.isInNonHosts(URL2)) {
            if (log.isDebugEnabled()) {
                log.debug("Conexi\u00f3n a trav\u00e9s de Proxy a " + URL2);
            }
            Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(System.getProperty("http.proxyHost"), Integer.parseInt(System.getProperty("http.proxyPort"))));
            conn = (HttpURLConnection)new URL(URL2).openConnection(proxy);
            if (System.getProperty("http.proxyUser") != null && !"".equals(System.getProperty("http.proxyUser"))) {
                if (log.isDebugEnabled()) {
                    log.debug("Proxy - Autenticando con " + System.getProperty("http.proxyUser"));
                }
                Authenticator.setDefault(new SimpleAuthenticator(System.getProperty("http.proxyUser"), System.getProperty("http.proxyPassword")));
                String encoded = new String(Base64.encode(new String(String.valueOf(System.getProperty("http.proxyUser")) + ":" + System.getProperty("http.proxyPassword")).getBytes()));
                conn.setRequestProperty("Proxy-Authorization", "NTLM " + encoded);
            }
        } else {
            if (log.isDebugEnabled()) {
                log.debug("Conexi\u00f3n directa a " + URL2);
            }
            conn = (HttpURLConnection)new URL(URL2).openConnection();
        }
        return conn;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isInNonHosts(String URL2) {
        try {
            String nonHostsList = System.getProperty("http.nonProxyHosts");
            if (nonHostsList == null) return false;
            if (nonHostsList.trim().length() <= 0) return false;
            StringTokenizer st = new StringTokenizer(nonHostsList, "|");
            block4: while (true) {
                if (!st.hasMoreTokens()) {
                    return false;
                }
                String host = st.nextToken();
                URL url = new URL(URL2);
                try {
                    InetAddress inet = InetAddress.getByName(host);
                    InetAddress inetDestino = InetAddress.getByName(url.getHost());
                    String ip = inet.getHostAddress();
                    String ipDestino = inetDestino.getHostAddress();
                    int j = 0;
                    while (j < ip.length() && ipDestino.charAt(j) == ip.charAt(j)) {
                        if (j > 0 && host.charAt(j) == '.') {
                            return true;
                        }
                        ++j;
                    }
                }
                catch (Exception e) {
                    log.debug("Error al comprobar la lista NonHosts por IP", e);
                    return false;
                }
                int i = 0;
                int lenght = host.length();
                while (true) {
                    if (!host.startsWith("*") && !host.startsWith(".") || i >= lenght) {
                        if (!url.getHost().contains(host)) continue block4;
                        if (!log.isDebugEnabled()) return true;
                        log.debug("URL filtrada para el proxy");
                        return true;
                    }
                    ++i;
                    host = host.substring(1);
                }
                break;
            }
        }
        catch (IOException e) {
            log.error("Error al comprobar la lista NonHosts", e);
            return false;
        }
    }
}

