/*
 * Decompiled with CFR 0.152.
 */
package es.mityc.javasign.utils;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class OSTool {
    private static final Log LOGGER = LogFactory.getLog(OSTool.class);
    private static final String STRING_EMPTY = "";
    private static final String STRING_BACKSLASH = "\\";
    private static final String OS_NAME = "os.name";
    private static final String OS_VERSION = "os.version";
    private static final String OS_ARCH = "os.arch";
    private static final String OS_ARCH_ALTERNATIVE = "sun.arch.data.model";
    private static final String WIN = "win";
    private static final String LINUX = "linux";
    private static final String MAC_OS = "mac os x";
    private static final String JAVAPLUGIN_VERSION = "javaplugin.version";
    private static final String USER_NAME = "user.name";
    private static final String FILE_SEPARATOR = "file.separator";
    public static final String[] WINDOWS4_NAMES = new String[]{"windows 95", "windows 98", "windows 2000", "windows 9x"};
    public static final String[] WINDOWS5_NAMES = new String[]{"windows 2000", "windows xp", "windows 2003", "windows nt"};
    public static final String[] WINDOWS6_NAMES = new String[]{"windows vista", "windows 7", "windows server 2008", "windows server 2008 r2"};
    public static final String[] WINDOWS_VERSIONS = new String[]{"4", "5", "6"};
    public static final String[] WINDOWS_ARCHS_64BITS = new String[]{"ia64", "amd64"};
    private static final int WINDOWS_DEFAULT_VERSION = 5;
    public static final String[] LINUX_VERSIONS = new String[]{"24", "26"};
    public static final String[] MACOSX_VERSIONS = new String[]{"104", "105", "106"};
    public static final String[] MACOSX_ARCHS_64BITS = new String[]{"x86_64"};
    public static final String[] SUN_ARCHS = new String[]{"32", "64"};
    private static OS actualSO = OSTool.askSO();
    private static boolean javaplugin = false;

    static {
        String pluginVersion = System.getProperty(JAVAPLUGIN_VERSION);
        if (pluginVersion != null) {
            javaplugin = true;
        }
    }

    private OSTool() {
    }

    private static boolean isWindows64bits() {
        boolean res = OSTool.isSun64bits();
        if (!res) {
            String osArch = System.getProperty(OS_ARCH).toLowerCase();
            int i = 0;
            while (i < WINDOWS_ARCHS_64BITS.length) {
                if (osArch.startsWith(WINDOWS_ARCHS_64BITS[i])) {
                    res = true;
                    break;
                }
                ++i;
            }
        }
        return res;
    }

    private static boolean isMacosx64bits() {
        boolean res = OSTool.isSun64bits();
        if (!res) {
            String osArch = System.getProperty(OS_ARCH).toLowerCase();
            int i = 0;
            while (i < MACOSX_ARCHS_64BITS.length) {
                if (osArch.startsWith(MACOSX_ARCHS_64BITS[i])) {
                    res = true;
                    break;
                }
                ++i;
            }
        }
        return res;
    }

    protected static boolean isSun64bits() {
        boolean res = false;
        String osArch = System.getProperty(OS_ARCH_ALTERNATIVE).toLowerCase();
        if (osArch != null && osArch.startsWith(SUN_ARCHS[1])) {
            res = true;
        }
        return res;
    }

    private static int getWindowsMajorVersion() {
        int version = 5;
        String osVersion = System.getProperty(OS_VERSION);
        try {
            version = Integer.parseInt(osVersion.substring(0, osVersion.indexOf(".")));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return version;
    }

    public static OS askSO() {
        OS res = OS.UNKNOWN;
        String osName = System.getProperty(OS_NAME);
        LOGGER.debug("SO: " + osName);
        if (osName.toLowerCase().startsWith(WIN)) {
            switch (OSTool.getWindowsMajorVersion()) {
                case 5: {
                    if (OSTool.isWindows64bits()) {
                        res = OS.WIN_5_64;
                        break;
                    }
                    res = OS.WIN_5_32;
                    break;
                }
                case 6: {
                    if (OSTool.isWindows64bits()) {
                        res = OS.WIN_6_64;
                        break;
                    }
                    res = OS.WIN_6_32;
                    break;
                }
                default: {
                    res = OSTool.isWindows64bits() ? OS.WIN_4_64 : OS.WIN_4_32;
                }
            }
            LOGGER.trace("Es un windows: " + (Object)((Object)res));
        } else if (osName.toLowerCase().startsWith(LINUX)) {
            LOGGER.trace("Es un linux");
            String osVersion = System.getProperty(OS_VERSION);
            res = osVersion.startsWith(LINUX_VERSIONS[0]) ? (OSTool.isSun64bits() ? OS.LIN_24_64 : OS.LIN_24_32) : (osVersion.startsWith(LINUX_VERSIONS[1]) ? (OSTool.isSun64bits() ? OS.LIN_26_64 : OS.LIN_26_32) : (OSTool.isSun64bits() ? OS.LIN_26_64 : OS.LIN_26_32));
        } else if (osName.toLowerCase().startsWith(MAC_OS)) {
            LOGGER.trace("Es un Mac OS X");
            String osVersion = System.getProperty(OS_VERSION);
            res = osVersion.startsWith(MACOSX_VERSIONS[0]) ? (OSTool.isMacosx64bits() ? OS.MACOSX_104_64 : OS.MACOSX_104_32) : (osVersion.startsWith(MACOSX_VERSIONS[1]) ? (OSTool.isMacosx64bits() ? OS.MACOSX_105_64 : OS.MACOSX_105_32) : (osVersion.startsWith(MACOSX_VERSIONS[2]) ? (OSTool.isMacosx64bits() ? OS.MACOSX_106_64 : OS.MACOSX_106_32) : (OSTool.isMacosx64bits() ? OS.MACOSX_106_64 : OS.MACOSX_106_32)));
        }
        return res;
    }

    public static OS getSO() {
        return actualSO;
    }

    public static boolean isPlugin() {
        return javaplugin;
    }

    public static boolean isOSLinux() {
        return System.getProperty(OS_NAME).toLowerCase().startsWith(LINUX);
    }

    public static boolean isOSWindows() {
        return System.getProperty(OS_NAME).toLowerCase().startsWith(WIN);
    }

    public static String getUserHome() {
        String home = System.getProperty("user.home");
        if (OSTool.isOSWindows()) {
            String path = home.substring(0, home.indexOf(STRING_BACKSLASH));
            return path.replace('\\', '/');
        }
        return home;
    }

    public static String getUserName() {
        return System.getProperty(USER_NAME);
    }

    public static String getFileSeparator() {
        if (OSTool.isOSWindows()) {
            return System.getProperty(FILE_SEPARATOR).replace('\\', '/');
        }
        return System.getProperty(FILE_SEPARATOR);
    }

    public static String getTempDir() {
        return System.getProperty("java.io.tmpdir");
    }

    public static String getHomeDir() {
        return OSTool.getUserHome();
    }

    public static enum OS {
        UNKNOWN(OS_NAMES.UNKNOWN, "", OS_BITS.UNKNOWN, "unknown"),
        WIN_4_32(OS_NAMES.WINDOWS, WINDOWS_VERSIONS[0], OS_BITS.OS32BITS, "Windows 4.0 32bits"),
        WIN_4_64(OS_NAMES.WINDOWS, WINDOWS_VERSIONS[0], OS_BITS.OS64BITS, "Windows 4.0 64bits"),
        WIN_5_32(OS_NAMES.WINDOWS, WINDOWS_VERSIONS[1], OS_BITS.OS32BITS, "Windows 5.0 32bits"),
        WIN_5_64(OS_NAMES.WINDOWS, WINDOWS_VERSIONS[1], OS_BITS.OS64BITS, "Windows 5.0 64bits"),
        WIN_6_32(OS_NAMES.WINDOWS, WINDOWS_VERSIONS[1], OS_BITS.OS32BITS, "Windows 6.0 32bits"),
        WIN_6_64(OS_NAMES.WINDOWS, WINDOWS_VERSIONS[1], OS_BITS.OS64BITS, "Windows 6.0 64bits"),
        LIN_24_32(OS_NAMES.LINUX, LINUX_VERSIONS[0], OS_BITS.OS32BITS, "Linux 2.4 32bits"),
        LIN_24_64(OS_NAMES.LINUX, LINUX_VERSIONS[0], OS_BITS.OS64BITS, "Linux 2.4 64bits"),
        LIN_26_32(OS_NAMES.LINUX, LINUX_VERSIONS[1], OS_BITS.OS32BITS, "Linux 2.6 32bits"),
        LIN_26_64(OS_NAMES.LINUX, LINUX_VERSIONS[1], OS_BITS.OS64BITS, "Linux 2.6 64bits"),
        MACOSX_104_32(OS_NAMES.MAC_OS_X, MACOSX_VERSIONS[0], OS_BITS.OS32BITS, "Mac OS X 10.4 32bits"),
        MACOSX_104_64(OS_NAMES.MAC_OS_X, MACOSX_VERSIONS[0], OS_BITS.OS64BITS, "Mac OS X 10.4 64bits"),
        MACOSX_105_32(OS_NAMES.MAC_OS_X, MACOSX_VERSIONS[1], OS_BITS.OS32BITS, "Mac OS X 10.5 32bits"),
        MACOSX_105_64(OS_NAMES.MAC_OS_X, MACOSX_VERSIONS[1], OS_BITS.OS64BITS, "Mac OS X 10.5 64bits"),
        MACOSX_106_32(OS_NAMES.MAC_OS_X, MACOSX_VERSIONS[1], OS_BITS.OS32BITS, "Mac OS X 10.6 32bits"),
        MACOSX_106_64(OS_NAMES.MAC_OS_X, MACOSX_VERSIONS[1], OS_BITS.OS64BITS, "Mac OS X 10.6 64bits");

        private OS_NAMES osvalue;
        private String version;
        private OS_BITS bits;
        private String desc;

        private OS(OS_NAMES osname, String osversion, OS_BITS osbits, String description) {
            this.osvalue = osname;
            this.version = osversion;
            this.bits = osbits;
            this.desc = new String(description);
        }

        public boolean isWindows() {
            return OS_NAMES.WINDOWS.equals((Object)this.osvalue);
        }

        public boolean isLinux() {
            return OS_NAMES.LINUX.equals((Object)this.osvalue);
        }

        public boolean isMacOsX() {
            return OS_NAMES.MAC_OS_X.equals((Object)this.osvalue);
        }

        public boolean is32bits() {
            return OS_BITS.OS32BITS.equals((Object)this.bits);
        }

        public boolean is64bits() {
            return OS_BITS.OS64BITS.equals((Object)this.bits);
        }

        public String getVersion() {
            return this.version;
        }

        public String toString() {
            return this.desc;
        }
    }

    public static enum OS_BITS {
        UNKNOWN,
        OS32BITS,
        OS64BITS;

    }

    public static enum OS_NAMES {
        UNKNOWN,
        WINDOWS,
        LINUX,
        MAC_OS_X;

    }
}

