/*
 * Decompiled with CFR 0.152.
 */
package es.mityc.firmaJava.libreria.xades;

import adsi.org.apache.xml.security.Init;
import es.mityc.firmaJava.libreria.excepciones.AddXadesException;
import es.mityc.firmaJava.libreria.utilidades.Base64Coder;
import es.mityc.firmaJava.libreria.utilidades.I18n;
import es.mityc.firmaJava.libreria.utilidades.NombreNodo;
import es.mityc.firmaJava.libreria.utilidades.UtilidadTratarNodo;
import es.mityc.firmaJava.libreria.xades.CanonicalizationEnum;
import es.mityc.firmaJava.libreria.xades.errores.FirmaXMLError;
import java.util.ArrayList;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

public class SignXAdEST {
    public static byte[] getDataToStamp(Element sign) throws AddXadesException {
        Init.init();
        try {
            return UtilidadTratarNodo.obtenerByteNodo(sign, "http://www.w3.org/2000/09/xmldsig#", "SignatureValue", CanonicalizationEnum.C14N_OMIT_COMMENTS, 5);
        }
        catch (FirmaXMLError ex) {
            throw new AddXadesException("Error procesando informaci\u00f3n a sellar: " + ex.getMessage(), ex);
        }
    }

    public static void addXAdEST(Element sign, byte[] ts) throws AddXadesException {
        Init.init();
        try {
            Document doc = sign.getOwnerDocument();
            Element qualifying = null;
            ArrayList<Element> qualifyings = UtilidadTratarNodo.obtenerNodos(sign, 2, new NombreNodo("*", "QualifyingProperties"));
            if (qualifyings == null || qualifyings.size() != 1) {
                throw new AddXadesException(I18n.getResource("libreriaxades.firmaxml.error18"));
            }
            qualifying = qualifyings.get(0);
            String xadesSchema = qualifying.getNamespaceURI();
            String xadesNS = qualifying.getPrefix();
            String xmldsigNS = sign.getPrefix();
            String firmaID = UtilidadTratarNodo.getId(sign);
            ArrayList<Element> signaturesValue = UtilidadTratarNodo.obtenerNodos(sign, 1, new NombreNodo("http://www.w3.org/2000/09/xmldsig#", "SignatureValue"));
            if (signaturesValue == null || signaturesValue.size() != 1) {
                throw new AddXadesException(I18n.getResource("libreriaxades.firmaxml.error18"));
            }
            String idSignatureValue = UtilidadTratarNodo.getId(signaturesValue.get(0));
            Element propiedadesElementosNoFirmados = null;
            ArrayList<Element> unsignedsProps = UtilidadTratarNodo.obtenerNodos(qualifying, 1, new NombreNodo(xadesSchema, "UnsignedProperties"));
            if (unsignedsProps == null || unsignedsProps.size() == 0) {
                propiedadesElementosNoFirmados = doc.createElementNS(xadesSchema, String.valueOf(xadesNS) + ":" + "UnsignedProperties");
                Attr propiedadesNoFirmadasId = doc.createAttributeNS(null, "Id");
                propiedadesNoFirmadasId.setValue(UtilidadTratarNodo.newID(doc, String.valueOf(firmaID) + "-UnsignedProperties"));
                NamedNodeMap atributosSinFirmarPropiedadesElemento = propiedadesElementosNoFirmados.getAttributes();
                atributosSinFirmarPropiedadesElemento.setNamedItem(propiedadesNoFirmadasId);
                qualifying.appendChild(propiedadesElementosNoFirmados);
            } else {
                propiedadesElementosNoFirmados = unsignedsProps.get(0);
            }
            Element propiedadesSinFirmarFirmaElementos = null;
            ArrayList<Element> unsignedsSigsProps = UtilidadTratarNodo.obtenerNodos(propiedadesElementosNoFirmados, 1, new NombreNodo(xadesSchema, "UnsignedSignatureProperties"));
            if (unsignedsSigsProps == null || unsignedsSigsProps.size() == 0) {
                propiedadesSinFirmarFirmaElementos = doc.createElementNS(xadesSchema, String.valueOf(xadesNS) + ":" + "UnsignedSignatureProperties");
                propiedadesElementosNoFirmados.appendChild(propiedadesSinFirmarFirmaElementos);
            } else {
                propiedadesSinFirmarFirmaElementos = unsignedsSigsProps.get(0);
            }
            Element tiempoSelloElementoFirma = doc.createElementNS(xadesSchema, String.valueOf(xadesNS) + ":" + "SignatureTimeStamp");
            Attr informacionElementoSigTimeStamp = doc.createAttributeNS(null, "Id");
            String idSelloTiempo = UtilidadTratarNodo.newID(doc, "SelloTiempo");
            informacionElementoSigTimeStamp.setValue(idSelloTiempo);
            tiempoSelloElementoFirma.getAttributes().setNamedItem(informacionElementoSigTimeStamp);
            if ("http://uri.etsi.org/01903/v1.1.1#".equals(xadesSchema) || "http://uri.etsi.org/01903/v1.2.2#".equals(xadesSchema)) {
                String nombreNodoUri = null;
                String tipoUri = null;
                if ("http://uri.etsi.org/01903/v1.1.1#".equals(xadesSchema)) {
                    nombreNodoUri = "HashDataInfo";
                    tipoUri = "uri";
                } else {
                    nombreNodoUri = "Include";
                    tipoUri = "URI";
                }
                Element informacionElementoHashDatos = doc.createElementNS(xadesSchema, String.valueOf(xadesNS) + ":" + nombreNodoUri);
                Attr informacionElementoHashDatosUri = doc.createAttributeNS(null, tipoUri);
                informacionElementoHashDatosUri.setValue("#" + idSignatureValue);
                NamedNodeMap informacionAtributosElementoHashDatos = informacionElementoHashDatos.getAttributes();
                informacionAtributosElementoHashDatos.setNamedItem(informacionElementoHashDatosUri);
                tiempoSelloElementoFirma.appendChild(informacionElementoHashDatos);
            }
            if (!"http://uri.etsi.org/01903/v1.1.1#".equals(xadesSchema)) {
                Element canonicalizationElemento = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", String.valueOf(xmldsigNS) + ":" + "CanonicalizationMethod");
                Attr canonicalizationAttribute = doc.createAttributeNS(null, "Algorithm");
                canonicalizationAttribute.setValue("http://www.w3.org/TR/2001/REC-xml-c14n-20010315");
                canonicalizationElemento.getAttributes().setNamedItem(canonicalizationAttribute);
                tiempoSelloElementoFirma.appendChild(canonicalizationElemento);
            }
            Element tiempoSelloEncapsulado = doc.createElementNS(xadesSchema, String.valueOf(xadesNS) + ":" + "EncapsulatedTimeStamp");
            tiempoSelloEncapsulado.appendChild(doc.createTextNode(new String(Base64Coder.encode(ts))));
            Attr tiempoSelloEncapsuladoId = doc.createAttributeNS(null, "Id");
            String idEncapsulated = UtilidadTratarNodo.newID(doc, "SelloTiempo-Token");
            tiempoSelloEncapsuladoId.setValue(idEncapsulated);
            tiempoSelloEncapsulado.getAttributes().setNamedItem(tiempoSelloEncapsuladoId);
            tiempoSelloElementoFirma.appendChild(tiempoSelloEncapsulado);
            propiedadesSinFirmarFirmaElementos.appendChild(tiempoSelloElementoFirma);
        }
        catch (FirmaXMLError ex) {
            throw new AddXadesException("Error incrustando sello de tiempo en firma XAdES: " + ex.getMessage(), ex);
        }
    }
}

