/*
 * Decompiled with CFR 0.152.
 */
package es.mityc.firmaJava.libreria.xades.elementos.xades;

import es.mityc.firmaJava.libreria.utilidades.Base64Coder;
import es.mityc.firmaJava.libreria.utilidades.UtilidadFirmaElectronica;
import es.mityc.firmaJava.libreria.xades.XAdESSchemas;
import es.mityc.firmaJava.libreria.xades.elementos.xades.AbstractXADESElement;
import es.mityc.firmaJava.libreria.xades.elementos.xmldsig.DigestMethod;
import es.mityc.firmaJava.libreria.xades.elementos.xmldsig.DigestValue;
import es.mityc.firmaJava.libreria.xades.errores.InvalidInfoNodeException;
import java.security.MessageDigest;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class DigestAlgAndValueType
extends AbstractXADESElement {
    private DigestMethod method;
    private DigestValue value;

    public DigestAlgAndValueType(XAdESSchemas schema) {
        super(schema);
    }

    public DigestAlgAndValueType(XAdESSchemas schema, String method, byte[] data) throws InvalidInfoNodeException {
        super(schema);
        MessageDigest md = UtilidadFirmaElectronica.getMessageDigest(method);
        if (md == null) {
            throw new InvalidInfoNodeException("M\u00e9todo desconocido para calcular el digest: " + method);
        }
        this.method = new DigestMethod(method);
        md.update(data);
        byte[] result = md.digest();
        this.value = new DigestValue(new String(Base64Coder.encode(result)));
    }

    public DigestAlgAndValueType(XAdESSchemas schema, String method, String value) {
        super(schema);
        this.method = new DigestMethod(method);
        this.value = new DigestValue(value);
    }

    public DigestMethod getDigestMethod() {
        return this.method;
    }

    public void setMethod(DigestMethod method) {
        this.method = method;
    }

    public DigestValue getDigestValue() {
        return this.value;
    }

    public void setValue(DigestValue value) {
        this.value = value;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof DigestAlgAndValueType) {
            DigestAlgAndValueType huella = (DigestAlgAndValueType)obj;
            if (!this.method.equals(huella.getDigestMethod())) {
                return false;
            }
            if (this.value.equals(huella.getDigestValue())) {
                return true;
            }
        }
        return false;
    }

    @Override
    public void load(Element element) throws InvalidInfoNodeException {
        DigestMethod method = new DigestMethod(null);
        Node node = DigestAlgAndValueType.getFirstNonvoidNode(element);
        if (!method.isThisNode(node)) {
            throw new InvalidInfoNodeException("Se esperaba nodo DigestMethod en DigestAlgAndValueType");
        }
        method.load((Element)node);
        node = DigestAlgAndValueType.getNextNonvoidNode(node);
        DigestValue value = new DigestValue(null);
        if (!value.isThisNode(node)) {
            throw new InvalidInfoNodeException("Se esperaba nodo DigestValue en DigestAlgAndValueType");
        }
        value.load((Element)node);
        this.method = method;
        this.value = value;
    }

    @Override
    public void addContent(Element element, String namespaceXAdES, String namespaceXDsig) throws InvalidInfoNodeException {
        super.addContent(element, namespaceXAdES, namespaceXDsig);
    }

    @Override
    protected void addContent(Element element) throws InvalidInfoNodeException {
        if (this.method == null || this.value == null) {
            throw new InvalidInfoNodeException("Informaci\u00f3n insuficiente para escribir nodo DigestAlgAndValueType");
        }
        element.appendChild(this.method.createElement(element.getOwnerDocument(), this.namespaceXDsig));
        element.appendChild(this.value.createElement(element.getOwnerDocument(), this.namespaceXDsig));
    }
}

