/*
 * Decompiled with CFR 0.152.
 */
package es.mityc.javasign.io;

import es.mityc.javasign.io.DecodingException;
import es.mityc.javasign.io.IDecoder;

public class Base64Decoder
implements IDecoder {
    private static final int BASE64_CHUNK_LENGTH = 4;
    private static final int BASE64_CHUNK_DECODED_LENGTH = 3;
    private byte[] buffer;
    private byte[] remaining;
    private boolean countMode;
    private long count = 0L;
    private static final byte[] BASE64_TO_INT;

    static {
        byte[] byArray = new byte[123];
        byArray[0] = -1;
        byArray[1] = -1;
        byArray[2] = -1;
        byArray[3] = -1;
        byArray[4] = -1;
        byArray[5] = -1;
        byArray[6] = -1;
        byArray[7] = -1;
        byArray[8] = -1;
        byArray[9] = -1;
        byArray[10] = -1;
        byArray[11] = -1;
        byArray[12] = -1;
        byArray[13] = -1;
        byArray[14] = -1;
        byArray[15] = -1;
        byArray[16] = -1;
        byArray[17] = -1;
        byArray[18] = -1;
        byArray[19] = -1;
        byArray[20] = -1;
        byArray[21] = -1;
        byArray[22] = -1;
        byArray[23] = -1;
        byArray[24] = -1;
        byArray[25] = -1;
        byArray[26] = -1;
        byArray[27] = -1;
        byArray[28] = -1;
        byArray[29] = -1;
        byArray[30] = -1;
        byArray[31] = -1;
        byArray[32] = -1;
        byArray[33] = -1;
        byArray[34] = -1;
        byArray[35] = -1;
        byArray[36] = -1;
        byArray[37] = -1;
        byArray[38] = -1;
        byArray[39] = -1;
        byArray[40] = -1;
        byArray[41] = -1;
        byArray[42] = -1;
        byArray[43] = 62;
        byArray[44] = -1;
        byArray[45] = -1;
        byArray[46] = -1;
        byArray[47] = 63;
        byArray[48] = 52;
        byArray[49] = 53;
        byArray[50] = 54;
        byArray[51] = 55;
        byArray[52] = 56;
        byArray[53] = 57;
        byArray[54] = 58;
        byArray[55] = 59;
        byArray[56] = 60;
        byArray[57] = 61;
        byArray[58] = -1;
        byArray[59] = -1;
        byArray[60] = -1;
        byArray[61] = -1;
        byArray[62] = -1;
        byArray[63] = -1;
        byArray[64] = -1;
        byArray[66] = 1;
        byArray[67] = 2;
        byArray[68] = 3;
        byArray[69] = 4;
        byArray[70] = 5;
        byArray[71] = 6;
        byArray[72] = 7;
        byArray[73] = 8;
        byArray[74] = 9;
        byArray[75] = 10;
        byArray[76] = 11;
        byArray[77] = 12;
        byArray[78] = 13;
        byArray[79] = 14;
        byArray[80] = 15;
        byArray[81] = 16;
        byArray[82] = 17;
        byArray[83] = 18;
        byArray[84] = 19;
        byArray[85] = 20;
        byArray[86] = 21;
        byArray[87] = 22;
        byArray[88] = 23;
        byArray[89] = 24;
        byArray[90] = 25;
        byArray[91] = -1;
        byArray[92] = -1;
        byArray[93] = -1;
        byArray[94] = -1;
        byArray[95] = -1;
        byArray[96] = -1;
        byArray[97] = 26;
        byArray[98] = 27;
        byArray[99] = 28;
        byArray[100] = 29;
        byArray[101] = 30;
        byArray[102] = 31;
        byArray[103] = 32;
        byArray[104] = 33;
        byArray[105] = 34;
        byArray[106] = 35;
        byArray[107] = 36;
        byArray[108] = 37;
        byArray[109] = 38;
        byArray[110] = 39;
        byArray[111] = 40;
        byArray[112] = 41;
        byArray[113] = 42;
        byArray[114] = 43;
        byArray[115] = 44;
        byArray[116] = 45;
        byArray[117] = 46;
        byArray[118] = 47;
        byArray[119] = 48;
        byArray[120] = 49;
        byArray[121] = 50;
        byArray[122] = 51;
        BASE64_TO_INT = byArray;
    }

    public Base64Decoder() {
        this(false);
    }

    public Base64Decoder(boolean onlyCountMode) {
        this.countMode = onlyCountMode;
    }

    public void reset() {
        this.count = 0L;
    }

    public long getCount() {
        return this.count;
    }

    @Override
    public void addInput(byte[] data, int pos, int len) {
        int totalLen = len + (this.buffer != null ? this.buffer.length : 0) + (this.remaining != null ? this.remaining.length : 0);
        byte[] temp = new byte[totalLen];
        int off = 0;
        if (this.remaining != null) {
            System.arraycopy(this.remaining, 0, temp, 0, this.remaining.length);
            off += this.remaining.length;
        }
        if (this.buffer != null) {
            System.arraycopy(this.buffer, 0, temp, off, this.buffer.length);
            off += this.buffer.length;
        }
        System.arraycopy(data, pos, temp, off, len);
        this.buffer = temp;
        this.remaining = null;
    }

    @Override
    public int decode(byte[] data, int off, int len) throws DecodingException {
        if (off < 0 || len < 0 || off > data.length - len) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (len < 3) {
            throw new DecodingException("Buffer too small, minimum size = 3");
        }
        int res = 0;
        if (this.buffer != null) {
            String s = new String(this.buffer).replace("\r\n", "").replace(" ", "").replace("\n", "");
            if (s.length() % 4 != 0) {
                this.remaining = s.substring(s.length() - s.length() % 4).getBytes();
                s = s.substring(0, s.length() - s.length() % 4);
            } else {
                this.remaining = null;
            }
            int len64 = s.length() * 3 / 4;
            if (s.endsWith("==")) {
                len64 -= 2;
            } else if (s.endsWith("=")) {
                --len64;
            }
            int actualLen = len;
            if (actualLen < len64) {
                actualLen -= actualLen % 3;
                this.buffer = s.substring(actualLen * 4 / 3).getBytes();
                s = s.substring(0, actualLen * 4 / 3 - 1);
            } else {
                this.buffer = null;
            }
            if (!this.countMode) {
                res = Base64Decoder.base64ToByteArray(s, data, off);
                this.count += (long)res;
            } else {
                this.count += (long)(s.length() * 3 / 4);
            }
        }
        return res;
    }

    private static int base64ToByteArray(String s, byte[] data, int off) {
        int sLen = s.length();
        int numGroups = sLen / 4;
        if (4 * numGroups != sLen) {
            throw new IllegalArgumentException("String length must be a multiple of four.");
        }
        int missingBytesInLastGroup = 0;
        int numFullGroups = numGroups;
        if (sLen != 0) {
            if (s.charAt(sLen - 1) == '=') {
                ++missingBytesInLastGroup;
                --numFullGroups;
            }
            if (s.charAt(sLen - 2) == '=') {
                ++missingBytesInLastGroup;
            }
        }
        int inCursor = 0;
        int outCursor = off;
        int i = 0;
        while (i < numFullGroups) {
            int ch0 = Base64Decoder.base64toInt(s.charAt(inCursor++), BASE64_TO_INT);
            int ch1 = Base64Decoder.base64toInt(s.charAt(inCursor++), BASE64_TO_INT);
            int ch2 = Base64Decoder.base64toInt(s.charAt(inCursor++), BASE64_TO_INT);
            int ch3 = Base64Decoder.base64toInt(s.charAt(inCursor++), BASE64_TO_INT);
            data[outCursor++] = (byte)(ch0 << 2 | ch1 >> 4);
            data[outCursor++] = (byte)(ch1 << 4 | ch2 >> 2);
            data[outCursor++] = (byte)(ch2 << 6 | ch3);
            ++i;
        }
        if (missingBytesInLastGroup != 0) {
            int ch0 = Base64Decoder.base64toInt(s.charAt(inCursor++), BASE64_TO_INT);
            int ch1 = Base64Decoder.base64toInt(s.charAt(inCursor++), BASE64_TO_INT);
            data[outCursor++] = (byte)(ch0 << 2 | ch1 >> 4);
            if (missingBytesInLastGroup == 1) {
                int ch2 = Base64Decoder.base64toInt(s.charAt(inCursor++), BASE64_TO_INT);
                data[outCursor++] = (byte)(ch1 << 4 | ch2 >> 2);
            }
        }
        return outCursor - off;
    }

    private static int base64toInt(char c, byte[] alphaToInt) {
        byte result = alphaToInt[c];
        if (result < 0) {
            throw new IllegalArgumentException("Illegal character " + c);
        }
        return result;
    }

    @Override
    public boolean needsInput() {
        return this.buffer == null;
    }

    @Override
    public boolean isIncomplete() {
        return this.remaining != null || this.buffer != null;
    }
}

