/*
 * Decompiled with CFR 0.152.
 */
package es.mityc.javasign.pass;

import es.mityc.javasign.i18n.I18nFactory;
import es.mityc.javasign.i18n.II18nManager;
import es.mityc.javasign.pass.IPassSecurity;
import es.mityc.javasign.pass.NullPassSecurity;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class PassSecurityFactory {
    private static final Log LOGGER = LogFactory.getLog(PassSecurityFactory.class);
    private static final II18nManager I18N = I18nFactory.getI18nManager("MITyCLibAPI");
    private static PassSecurityFactory instance = PassSecurityFactory.getInstance();
    private List<Properties> props = null;
    private static final String PASS_SECURITY_FILE_CONF = "META-INF/pass/security.properties";

    private PassSecurityFactory() {
        this.loadManagers();
    }

    private void loadManagers() {
        ClassLoader cl = PassSecurityFactory.getClassLoader();
        try {
            Enumeration<URL> en = cl.getResources(PASS_SECURITY_FILE_CONF);
            this.props = new ArrayList<Properties>();
            while (en.hasMoreElements()) {
                URL url = en.nextElement();
                try {
                    InputStream is = url.openStream();
                    Properties properties = new Properties();
                    properties.load(is);
                    this.props.add(properties);
                }
                catch (IOException ex) {
                    LOGGER.error(I18N.getLocalMessage("i18n.mityc.api.pass.2", url, ex.getMessage()));
                }
            }
        }
        catch (IOException ex) {
            LOGGER.error(I18N.getLocalMessage("i18n.mityc.api.pass.1", ex.getMessage()));
        }
    }

    private static ClassLoader getClassLoader() {
        try {
            ClassLoader cl = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                @Override
                public ClassLoader run() {
                    ClassLoader classLoader = null;
                    try {
                        classLoader = Thread.currentThread().getContextClassLoader();
                    }
                    catch (SecurityException securityException) {
                        // empty catch block
                    }
                    return classLoader;
                }
            });
            if (cl != null) {
                return cl;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return PassSecurityFactory.class.getClassLoader();
    }

    public static PassSecurityFactory getInstance() {
        if (instance == null) {
            instance = new PassSecurityFactory();
        }
        return instance;
    }

    public IPassSecurity getPassSecurityManager(String key, boolean defaultManager) {
        IPassSecurity secManager = null;
        if (this.props != null && this.props.size() > 0) {
            for (Properties prop : this.props) {
                block23: {
                    String classname = prop.getProperty(key);
                    if (classname == null) continue;
                    try {
                        ClassLoader cl = PassSecurityFactory.getClassLoader();
                        Class<?> manager = null;
                        manager = cl != null ? cl.loadClass(classname) : Class.forName(classname);
                        if (manager != null) {
                            Constructor<?> constructor = manager.getConstructor(Properties.class);
                            if (constructor != null) {
                                secManager = (IPassSecurity)constructor.newInstance(prop);
                            } else {
                                constructor = manager.getConstructor(null);
                                if (constructor != null) {
                                    secManager = (IPassSecurity)constructor.newInstance(new Object[0]);
                                }
                            }
                        }
                    }
                    catch (InstantiationException ex) {
                        LOGGER.warn(I18N.getLocalMessage("i18n.mityc.api.pass.3", ex.getMessage()));
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug("", ex);
                        }
                    }
                    catch (IllegalAccessException ex) {
                        LOGGER.warn(I18N.getLocalMessage("i18n.mityc.api.pass.3", ex.getMessage()));
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug("", ex);
                        }
                    }
                    catch (ClassNotFoundException ex) {
                        LOGGER.warn(I18N.getLocalMessage("i18n.mityc.api.pass.3", ex.getMessage()));
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug("", ex);
                        }
                    }
                    catch (ClassCastException ex) {
                        LOGGER.warn(I18N.getLocalMessage("i18n.mityc.api.pass.3", ex.getMessage()));
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug("", ex);
                        }
                    }
                    catch (SecurityException ex) {
                        LOGGER.warn(I18N.getLocalMessage("i18n.mityc.api.pass.3", ex.getMessage()));
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug("", ex);
                        }
                    }
                    catch (NoSuchMethodException ex) {
                        LOGGER.warn(I18N.getLocalMessage("i18n.mityc.api.pass.3", ex.getMessage()));
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug("", ex);
                        }
                    }
                    catch (IllegalArgumentException ex) {
                        LOGGER.warn(I18N.getLocalMessage("i18n.mityc.api.pass.3", ex.getMessage()));
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug("", ex);
                        }
                    }
                    catch (InvocationTargetException ex) {
                        LOGGER.warn(I18N.getLocalMessage("i18n.mityc.api.pass.3", ex.getMessage()));
                        if (!LOGGER.isDebugEnabled()) break block23;
                        LOGGER.debug("", ex);
                    }
                }
                if (secManager != null || !defaultManager) continue;
                secManager = new NullPassSecurity();
            }
        }
        if (secManager == null && defaultManager) {
            secManager = new NullPassSecurity();
        }
        return secManager;
    }
}

