/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.crypto.dsig;

import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.util.Map;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dsig.Transform;
import javax.xml.crypto.dsig.XMLDSigSecurity;
import javax.xml.crypto.dsig.spec.TransformParameterSpec;

public abstract class TransformService
implements Transform {
    private String algorithm;
    private String mechanism;
    private Provider provider;

    protected TransformService() {
    }

    public static TransformService getInstance(String algorithm, String mechanismType) throws NoSuchAlgorithmException {
        if (mechanismType == null || algorithm == null) {
            throw new NullPointerException();
        }
        return TransformService.findInstance(algorithm, mechanismType, null);
    }

    public static TransformService getInstance(String algorithm, String mechanismType, Provider provider) throws NoSuchAlgorithmException {
        if (mechanismType == null || algorithm == null || provider == null) {
            throw new NullPointerException();
        }
        return TransformService.findInstance(algorithm, mechanismType, provider);
    }

    public static TransformService getInstance(String algorithm, String mechanismType, String provider) throws NoSuchAlgorithmException, NoSuchProviderException {
        if (mechanismType == null || algorithm == null || provider == null) {
            throw new NullPointerException();
        }
        Provider prov = Security.getProvider(provider);
        if (prov == null) {
            throw new NoSuchProviderException("cannot find provider named " + provider);
        }
        return TransformService.findInstance(algorithm, mechanismType, prov);
    }

    private static TransformService findInstance(String algorithm, String mechanismType, Provider provider) throws NoSuchAlgorithmException {
        Object[] objs = XMLDSigSecurity.getImpl(algorithm, new MechanismMapEntry(algorithm, mechanismType), "TransformService", provider);
        TransformService spi = (TransformService)objs[0];
        spi.mechanism = mechanismType;
        spi.algorithm = algorithm;
        spi.provider = (Provider)objs[1];
        return spi;
    }

    public final String getMechanismType() {
        return this.mechanism;
    }

    @Override
    public final String getAlgorithm() {
        return this.algorithm;
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public abstract void init(TransformParameterSpec var1) throws InvalidAlgorithmParameterException;

    public abstract void marshalParams(XMLStructure var1, XMLCryptoContext var2) throws MarshalException;

    public abstract void init(XMLStructure var1, XMLCryptoContext var2) throws InvalidAlgorithmParameterException;

    private static class MechanismMapEntry
    implements Map.Entry {
        private final String mechanism;
        private final String key;

        MechanismMapEntry(String algorithm, String mechanism) {
            this.mechanism = mechanism;
            this.key = "TransformService." + algorithm + " MechanismType";
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return (this.getKey() == null ? e.getKey() == null : this.getKey().equals(e.getKey())) && (this.getValue() == null ? e.getValue() == null : this.getValue().equals(e.getValue()));
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.mechanism;
        }

        public Object setValue(Object value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int hashCode() {
            return (this.getKey() == null ? 0 : this.getKey().hashCode()) ^ (this.getValue() == null ? 0 : this.getValue().hashCode());
        }
    }
}

