/*
 * Decompiled with CFR 0.152.
 */
package org.jcp.xml.dsig.internal.dom;

import java.security.Provider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dom.DOMCryptoContext;
import javax.xml.crypto.dsig.XMLObject;
import org.jcp.xml.dsig.internal.dom.DOMManifest;
import org.jcp.xml.dsig.internal.dom.DOMSignatureProperties;
import org.jcp.xml.dsig.internal.dom.DOMStructure;
import org.jcp.xml.dsig.internal.dom.DOMUtils;
import org.jcp.xml.dsig.internal.dom.DOMX509Data;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class DOMXMLObject
extends DOMStructure
implements XMLObject {
    private final String id;
    private final String mimeType;
    private final String encoding;
    private final List content;

    public DOMXMLObject(List content, String id, String mimeType, String encoding) {
        if (content == null || content.isEmpty()) {
            this.content = Collections.EMPTY_LIST;
        } else {
            ArrayList contentCopy = new ArrayList(content);
            int i = 0;
            int size = contentCopy.size();
            while (i < size) {
                if (!(contentCopy.get(i) instanceof XMLStructure)) {
                    throw new ClassCastException("content[" + i + "] is not a valid type");
                }
                ++i;
            }
            this.content = Collections.unmodifiableList(contentCopy);
        }
        this.id = id;
        this.mimeType = mimeType;
        this.encoding = encoding;
    }

    /*
     * Unable to fully structure code
     */
    public DOMXMLObject(Element objElem, XMLCryptoContext context, Provider provider) throws MarshalException {
        super();
        this.encoding = DOMUtils.getAttributeValue(objElem, "Encoding");
        this.id = DOMUtils.getAttributeValue(objElem, "Id");
        this.mimeType = DOMUtils.getAttributeValue(objElem, "MimeType");
        nodes = objElem.getChildNodes();
        length = nodes.getLength();
        content = new ArrayList<XMLStructure>(length);
        i = 0;
        while (i < length) {
            child = nodes.item(i);
            if (child.getNodeType() != 1) ** GOTO lbl-1000
            childElem = (Element)child;
            tag = childElem.getLocalName();
            if (tag.equals("Manifest")) {
                content.add(new DOMManifest(childElem, context, provider));
            } else if (tag.equals("SignatureProperties")) {
                content.add(new DOMSignatureProperties(childElem));
            } else if (tag.equals("X509Data")) {
                content.add(new DOMX509Data(childElem));
            } else lbl-1000:
            // 2 sources

            {
                content.add(new javax.xml.crypto.dom.DOMStructure(child));
            }
            ++i;
        }
        this.content = content.isEmpty() != false ? Collections.EMPTY_LIST : Collections.unmodifiableList(content);
    }

    @Override
    public List getContent() {
        return this.content;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getMimeType() {
        return this.mimeType;
    }

    @Override
    public String getEncoding() {
        return this.encoding;
    }

    @Override
    public void marshal(Node parent, String dsPrefix, DOMCryptoContext context) throws MarshalException {
        Document ownerDoc = DOMUtils.getOwnerDocument(parent);
        Element objElem = DOMUtils.createElement(ownerDoc, "Object", "http://www.w3.org/2000/09/xmldsig#", dsPrefix);
        DOMUtils.setAttributeID(objElem, "Id", this.id);
        DOMUtils.setAttribute(objElem, "MimeType", this.mimeType);
        DOMUtils.setAttribute(objElem, "Encoding", this.encoding);
        int i = 0;
        int size = this.content.size();
        while (i < size) {
            XMLStructure object = (XMLStructure)this.content.get(i);
            if (object instanceof DOMStructure) {
                ((DOMStructure)object).marshal(objElem, dsPrefix, context);
            } else {
                javax.xml.crypto.dom.DOMStructure domObject = (javax.xml.crypto.dom.DOMStructure)object;
                DOMUtils.appendChild(objElem, domObject.getNode());
            }
            ++i;
        }
        parent.appendChild(objElem);
    }

    public boolean equals(Object o) {
        boolean mimeTypesEqual;
        boolean encodingsEqual;
        boolean idsEqual;
        if (this == o) {
            return true;
        }
        if (!(o instanceof XMLObject)) {
            return false;
        }
        XMLObject oxo = (XMLObject)o;
        boolean bl = this.id == null ? oxo.getId() == null : (idsEqual = this.id.equals(oxo.getId()));
        boolean bl2 = this.encoding == null ? oxo.getEncoding() == null : (encodingsEqual = this.encoding.equals(oxo.getEncoding()));
        boolean bl3 = this.mimeType == null ? oxo.getMimeType() == null : (mimeTypesEqual = this.mimeType.equals(oxo.getMimeType()));
        return idsEqual && encodingsEqual && mimeTypesEqual && this.equalsContent(oxo.getContent());
    }

    public int hashCode() {
        assert (false) : "hashCode not designed";
        return 53;
    }

    private boolean equalsContent(List otherContent) {
        if (this.content.size() != otherContent.size()) {
            return false;
        }
        int i = 0;
        int osize = otherContent.size();
        while (i < osize) {
            XMLStructure oxs = (XMLStructure)otherContent.get(i);
            XMLStructure xs = (XMLStructure)this.content.get(i);
            if (oxs instanceof javax.xml.crypto.dom.DOMStructure) {
                if (!(xs instanceof javax.xml.crypto.dom.DOMStructure)) {
                    return false;
                }
                Node onode = ((javax.xml.crypto.dom.DOMStructure)oxs).getNode();
                Node node = ((javax.xml.crypto.dom.DOMStructure)xs).getNode();
                if (!DOMUtils.nodesEqual(node, onode)) {
                    return false;
                }
            } else if (!xs.equals(oxs)) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

