/*
 * Decompiled with CFR 0.152.
 */
package com.detzerg.firmaelectronica;

import com.detzerg.firmaelectronica.AutoridadesCertificantes;
import com.detzerg.firmaelectronica.PassStoreKS;
import com.detzerg.firmaelectronica.TokensValidos;
import com.detzerg.firmaelectronica.X500NameGeneral;
import es.mityc.firmaJava.libreria.utilidades.UtilidadTratarNodo;
import es.mityc.firmaJava.libreria.xades.DataToSign;
import es.mityc.firmaJava.libreria.xades.FirmaXML;
import es.mityc.javasign.pkstore.CertStoreException;
import es.mityc.javasign.pkstore.IPKStoreManager;
import es.mityc.javasign.pkstore.keystore.KSStore;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public abstract class GenericXMLSignature {
    public String PKCS12_RESOURCE = "/examples/usr0061.p12";
    public String PKCS12_PASSWORD = "miclave";
    public String OUTPUT_DIRECTORY;

    public void setOUTPUT_DIRECTORY(String OUTPUT_DIRECTORY) {
        this.OUTPUT_DIRECTORY = OUTPUT_DIRECTORY;
    }

    protected boolean execute() {
        try {
            X509Certificate certificate;
            KSStore storeManager = null;
            String aliaskey = null;
            KeyStore ks = null;
            String store = "pkcs12";
            ks = KeyStore.getInstance(store);
            if (store == "Windows-MY") {
                ks.load(this.getClass().getResourceAsStream(this.PKCS12_RESOURCE), this.PKCS12_PASSWORD.toCharArray());
                ks.load(null, null);
                storeManager = new KSStore(ks, new PassStoreKS(this.PKCS12_PASSWORD));
            } else if (store.equals("pkcs12")) {
                ks.load(new FileInputStream(this.PKCS12_RESOURCE), this.PKCS12_PASSWORD.toCharArray());
                ks.load(null, null);
                storeManager = new KSStore(ks, new PassStoreKS(this.PKCS12_PASSWORD));
            }
            if (storeManager == null) {
                System.err.println("Error=El gestor de claves no se ha obtenido correctamente.");
                return false;
            }
            TokensValidos tokenID = null;
            if (tokenID == null) {
                tokenID = TokensValidos.valueOf("BCE_IKEY2032");
            }
            if ((certificate = (X509Certificate)ks.getCertificate(aliaskey = GenericXMLSignature.seleccionarCertificado(ks, tokenID))) == null) {
                System.err.println("Error=No existe ning\u00fan certificado para firmar");
                return false;
            }
            PrivateKey privateKey = null;
            try {
                KeyStore tmpKs = ks;
                privateKey = (PrivateKey)tmpKs.getKey(aliaskey, this.PKCS12_PASSWORD.toCharArray());
            }
            catch (UnrecoverableKeyException ex) {
                Logger.getLogger(GenericXMLSignature.class.getName()).log(Level.SEVERE, null, ex);
            }
            Provider provider = storeManager.getProvider(certificate);
            DataToSign dataToSign = this.createDataToSign();
            FirmaXML firma = new FirmaXML();
            Document docSigned = null;
            try {
                Object[] res = firma.signFile(certificate, dataToSign, privateKey, provider);
                docSigned = (Document)res[0];
            }
            catch (Exception ex) {
                System.err.println("Error=Error Signed File");
                ex.printStackTrace();
                return false;
            }
            String filePath = this.OUTPUT_DIRECTORY + File.separatorChar + this.getSignatureFileName();
            System.out.println("Ok=File signed in: " + filePath);
            this.saveDocumentToFile(docSigned, filePath);
            return true;
        }
        catch (KeyStoreException ex) {
            System.err.println("Error=Signature failed, vetify your file or password");
        }
        catch (IOException ex) {
            System.err.println("Error=Signature failed, verify your file or password");
        }
        catch (NoSuchAlgorithmException ex) {
            System.err.println("Error=Signature failed, verify your file or password");
        }
        catch (CertificateNotYetValidException ex) {
            System.err.println("Error=Signature failed, verify your file or password");
        }
        catch (CertificateException ex) {
            System.err.println("Error=Signature failed, verify your file or password");
        }
        return false;
    }

    protected abstract DataToSign createDataToSign();

    protected abstract String getSignatureFileName();

    private void saveDocumentToFile(Document document, String pathfile) {
        try {
            FileOutputStream fos = new FileOutputStream(pathfile);
            UtilidadTratarNodo.saveDocumentToOutputStream(document, fos, true);
        }
        catch (FileNotFoundException e) {
            System.err.println("Error=Error to save signed document");
        }
    }

    private void saveDocumentToFileUnsafeMode(Document document, String pathfile) {
        TransformerFactory tfactory = TransformerFactory.newInstance();
        try {
            Transformer serializer = tfactory.newTransformer();
            serializer.transform(new DOMSource(document), new StreamResult(new File(pathfile)));
        }
        catch (TransformerException e) {
            System.err.println("Error=Error to save signed document");
            e.printStackTrace();
        }
    }

    protected Document getDocument(String resource) {
        Document doc = null;
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        File fXmlFile = new File(resource);
        dbf.setNamespaceAware(true);
        try {
            DocumentBuilder dBuilder = dbf.newDocumentBuilder();
            doc = dBuilder.parse(fXmlFile);
        }
        catch (ParserConfigurationException ex) {
            System.err.println(GenericXMLSignature.class.getName() + " " + ex.getMessage());
        }
        catch (SAXException ex) {
            System.err.println(GenericXMLSignature.class.getName() + " " + ex.getMessage());
        }
        catch (IOException ex) {
            System.err.println(GenericXMLSignature.class.getName() + " " + ex.getMessage());
        }
        return doc;
    }

    protected String getDocumentAsString(String resource) {
        Document doc = this.getDocument(resource);
        TransformerFactory tfactory = TransformerFactory.newInstance();
        StringWriter stringWriter = new StringWriter();
        try {
            Transformer serializer = tfactory.newTransformer();
            serializer.transform(new DOMSource(doc), new StreamResult(stringWriter));
        }
        catch (TransformerException e) {
            System.err.println("Error al imprimir el documento");
            e.printStackTrace();
        }
        return stringWriter.toString();
    }

    private X509Certificate getFirstCertificate(IPKStoreManager storeManager) {
        List<X509Certificate> certs = null;
        try {
            certs = storeManager.getSignCertificates();
        }
        catch (CertStoreException ex) {
            System.err.println("Error=Fallo obteniendo listado de certificados");
            return null;
        }
        if (certs == null || certs.size() == 0) {
            System.err.println("Error=Lista de certificados vac\u00eda");
            return null;
        }
        X509Certificate certificate = certs.get(0);
        return certificate;
    }

    public static String seleccionarCertificado(KeyStore keyStore, TokensValidos tokenSeleccionado) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateExpiredException, CertificateNotYetValidException, CertificateException {
        String aliasSeleccion = null;
        X509Certificate certificado = null;
        Enumeration<String> nombres = keyStore.aliases();
        while (nombres.hasMoreElements()) {
            String aliasKey = nombres.nextElement();
            certificado = (X509Certificate)keyStore.getCertificate(aliasKey);
            X500NameGeneral x500emisor = new X500NameGeneral(certificado.getIssuerDN().getName());
            X500NameGeneral x500sujeto = new X500NameGeneral(certificado.getSubjectDN().getName());
            if (tokenSeleccionado.equals((Object)TokensValidos.SD_BIOPASS) || tokenSeleccionado.equals((Object)TokensValidos.SD_EPASS3000) && x500emisor.getCN().contains(AutoridadesCertificantes.SECURITY_DATA.getCn())) {
                if (!AutoridadesCertificantes.SECURITY_DATA.getO().equals(x500emisor.getO()) || !AutoridadesCertificantes.SECURITY_DATA.getC().equals(x500emisor.getC()) || !AutoridadesCertificantes.SECURITY_DATA.getO().equals(x500sujeto.getO()) || !AutoridadesCertificantes.SECURITY_DATA.getC().equals(x500sujeto.getC()) || !certificado.getKeyUsage()[0] && !certificado.getKeyUsage()[1]) continue;
                aliasSeleccion = aliasKey;
                break;
            }
            if (tokenSeleccionado.equals((Object)TokensValidos.BCE_ALADDIN) || tokenSeleccionado.equals((Object)TokensValidos.BCE_IKEY2032) && x500emisor.getCN().contains(AutoridadesCertificantes.BANCO_CENTRAL.getCn())) {
                if (!x500emisor.getO().contains(AutoridadesCertificantes.BANCO_CENTRAL.getO()) || !AutoridadesCertificantes.BANCO_CENTRAL.getC().equals(x500emisor.getC()) || !x500sujeto.getO().contains(AutoridadesCertificantes.BANCO_CENTRAL.getO()) || !AutoridadesCertificantes.BANCO_CENTRAL.getC().equals(x500sujeto.getC()) || !certificado.getKeyUsage()[0] && !certificado.getKeyUsage()[1]) continue;
                aliasSeleccion = aliasKey;
                break;
            }
            if (tokenSeleccionado.equals((Object)TokensValidos.ANF1) && x500emisor.getCN().contains(AutoridadesCertificantes.ANF.getCn())) {
                if (!AutoridadesCertificantes.ANF.getO().equals(x500emisor.getO()) || !AutoridadesCertificantes.ANF.getC().equals(x500emisor.getC()) || !AutoridadesCertificantes.ANF.getC().toLowerCase().equals(x500sujeto.getC()) || !certificado.getKeyUsage()[0] && !certificado.getKeyUsage()[1]) continue;
                aliasSeleccion = aliasKey;
                break;
            }
            if (tokenSeleccionado.equals((Object)TokensValidos.ANF1) && x500emisor.getCN().contains(AutoridadesCertificantes.ANF_ECUADOR_CA1.getCn())) {
                if (!AutoridadesCertificantes.ANF_ECUADOR_CA1.getO().equals(x500emisor.getO()) || !AutoridadesCertificantes.ANF_ECUADOR_CA1.getC().equals(x500emisor.getC()) || !AutoridadesCertificantes.ANF_ECUADOR_CA1.getC().equals(x500sujeto.getC()) || !certificado.getKeyUsage()[0] && !certificado.getKeyUsage()[1]) continue;
                aliasSeleccion = aliasKey;
                break;
            }
            if (!tokenSeleccionado.equals((Object)TokensValidos.KEY4_CONSEJO_JUDICATURA) || !x500emisor.getCN().contains(AutoridadesCertificantes.CONSEJO_JUDICATURA.getCn()) || !x500emisor.getO().contains(AutoridadesCertificantes.CONSEJO_JUDICATURA.getO()) || !AutoridadesCertificantes.CONSEJO_JUDICATURA.getC().equals(x500emisor.getC()) || !AutoridadesCertificantes.CONSEJO_JUDICATURA.getC().equals(x500sujeto.getC()) || !certificado.getKeyUsage()[0] && !certificado.getKeyUsage()[1]) continue;
            aliasSeleccion = aliasKey;
            break;
        }
        return aliasSeleccion;
    }
}

