/*
 * Decompiled with CFR 0.152.
 */
package es.mityc.javasign.asn1;

import es.mityc.javasign.certificate.OCSPResponderID;
import es.mityc.javasign.i18n.I18nFactory;
import es.mityc.javasign.i18n.II18nManager;
import java.io.IOException;
import javax.security.auth.x500.X500Principal;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.ocsp.ResponderID;
import org.bouncycastle.asn1.x509.X509Name;

public class ASN1Utils {
    private static Log LOG = LogFactory.getLog(ASN1Utils.class);
    private static II18nManager I18N = I18nFactory.getI18nManager("MITyCLibXAdES");

    private ASN1Utils() {
    }

    public static OCSPResponderID getResponderID(ResponderID responder) {
        OCSPResponderID result = null;
        ASN1TaggedObject tagged = (ASN1TaggedObject)responder.toASN1Object();
        switch (tagged.getTagNo()) {
            case 1: {
                try {
                    X509Name name = X509Name.getInstance((Object)tagged.getObject());
                    result = OCSPResponderID.getOCSPResponderID(new X500Principal(name.getEncoded()));
                }
                catch (IllegalArgumentException ex) {
                    LOG.error(I18N.getLocalMessage("i18n.mityc.xades.utils.1", ex.getMessage()));
                    if (!LOG.isDebugEnabled()) break;
                    LOG.debug("", ex);
                }
                catch (IOException ex) {
                    LOG.error(I18N.getLocalMessage("i18n.mityc.xades.utils.1", ex.getMessage()));
                    if (!LOG.isDebugEnabled()) break;
                    LOG.debug("", ex);
                }
                break;
            }
            case 2: {
                ASN1OctetString octect = (ASN1OctetString)tagged.getObject();
                result = OCSPResponderID.getOCSPResponderID(octect.getOctets());
            }
        }
        return result;
    }
}

